/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.jmeter.HttpSample;
import hudson.plugins.jmeter.JMeterBuildAction;
import hudson.plugins.jmeter.UriReport;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.Digester;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterReport
implements ModelObject {
    private JMeterBuildAction buildAction;
    private final Map<String, UriReport> uriReportMap = new HashMap<String, UriReport>();

    JMeterReport() {
    }

    JMeterReport(JMeterBuildAction buildAction, File pFile) throws IOException {
        this.buildAction = buildAction;
        Digester digester = this.createDigester();
        try {
            digester.parse(pFile);
        }
        catch (SAXException e) {
            throw new IOException2("Failed to parse " + pFile, (Throwable)e);
        }
    }

    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null || uri.contains("/")) {
            throw new SAXException("lb cannot be empty or containing '/' character, please ensure your jmx file specifies name properly for each http sample");
        }
        UriReport uriReport = this.uriReportMap.get(uri);
        if (uriReport == null) {
            uriReport = new UriReport(this, uri);
            this.uriReportMap.put(uri, uriReport);
        }
        uriReport.addHttpSample(pHttpSample);
    }

    public int countErrors() {
        int nbError = 0;
        for (UriReport currentReport : this.uriReportMap.values()) {
            nbError += currentReport.countErrors();
        }
        return nbError;
    }

    private Digester createDigester() {
        Digester digester = new Digester();
        digester.setClassLoader(this.getClass().getClassLoader());
        digester.push((Object)this);
        digester.addObjectCreate("*/httpSample", HttpSample.class);
        String[] attributeNames = new String[]{"lb", "ts", "t", "s"};
        String[] propertyNames = new String[]{"uri", "time", "duration", "successful"};
        digester.addSetProperties("*/httpSample", attributeNames, propertyNames);
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                return new Date(Long.valueOf(value.toString()));
            }
        }, Date.class);
        digester.addSetNext("*/httpSample", "addSample");
        return digester;
    }

    public long getAverage() {
        long average = 0L;
        for (UriReport currentReport : this.uriReportMap.values()) {
            average += currentReport.getAverage() * (long)currentReport.size();
        }
        return average / (long)this.size();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    public String getDisplayName() {
        return "JMeter";
    }

    public UriReport getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return this.getUriReportMap().get(token);
    }

    public long getMax() {
        long max = Long.MIN_VALUE;
        for (UriReport currentReport : this.uriReportMap.values()) {
            max = Math.max(currentReport.getMax(), max);
        }
        return max;
    }

    public long getMin() {
        long min = Long.MAX_VALUE;
        for (UriReport currentReport : this.uriReportMap.values()) {
            min = Math.min(currentReport.getMin(), min);
        }
        return min;
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    public int size() {
        int size = 0;
        for (UriReport currentReport : this.uriReportMap.values()) {
            size += currentReport.size();
        }
        return size;
    }
}

