/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.jmeter.JMeterPublisher;
import hudson.plugins.jmeter.JMeterReport;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterBuildAction
implements Action,
StaplerProxy {
    private static final Logger logger = Logger.getLogger((String)JMeterBuildAction.class.getName());
    private static final long serialVersionUID = 1L;
    private transient WeakReference<JMeterReport> jmeterReport;
    private final transient PrintStream hudsonConsoleWriter;
    private final AbstractBuild<?, ?> build;

    public JMeterBuildAction(AbstractBuild<?, ?> pBuild, PrintStream logger) {
        this.build = pBuild;
        this.hudsonConsoleWriter = logger;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getDisplayName() {
        return "JMeter report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public JMeterReport getJmeterReport() {
        JMeterReport meterReport = null;
        if (this.jmeterReport == null || this.jmeterReport.get() == null) {
            File reportFile = JMeterPublisher.getJMeterReport(this.getBuild());
            try {
                meterReport = new JMeterReport(this, reportFile);
                if (meterReport.size() == 0) {
                    this.hudsonConsoleWriter.println("jmeter report analysis is empty, ensure your jtl file is filled with samples.");
                }
                this.jmeterReport = new WeakReference<JMeterReport>(meterReport);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load " + reportFile), (Throwable)e);
                Throwable ex = e;
                do {
                    this.hudsonConsoleWriter.println(ex.getLocalizedMessage());
                } while ((ex = ex.getCause()) != null);
            }
        } else {
            meterReport = (JMeterReport)this.jmeterReport.get();
        }
        return meterReport;
    }

    PrintStream getHudsonConsoleWriter() {
        return this.hudsonConsoleWriter;
    }

    public Object getTarget() {
        return this.getJmeterReport();
    }

    public String getUrlName() {
        return "jmeter";
    }

    public boolean isFailed() {
        return this.getJmeterReport() == null;
    }
}

