/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.jmeter.JMeterBuildAction;
import hudson.plugins.jmeter.JMeterProjectAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterPublisher
extends Publisher {
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private String filename;

    public static File getJMeterReport(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "jmeter.xml");
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getFilename() {
        return this.filename;
    }

    public Action getProjectAction(Project project) {
        return new JMeterProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println("Recording JMeter reports " + this.getFilename());
        FilePath src = build.getProject().getWorkspace().child(this.getFilename());
        if (!src.exists()) {
            if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                return true;
            }
            logger.println("JMeter file " + src + " not found. Has the report generated?");
            build.setResult(Result.FAILURE);
            return true;
        }
        File localReport = JMeterPublisher.getJMeterReport(build);
        src.copyTo(new FilePath(localReport));
        JMeterBuildAction jmeterBuildAction = new JMeterBuildAction(build, logger);
        build.addAction((Action)jmeterBuildAction);
        if (jmeterBuildAction.isFailed()) {
            logger.println("JMeter report analysis failed. Setting Build to unstable.");
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        protected DescriptorImpl() {
            super(JMeterPublisher.class);
        }

        public String getDisplayName() {
            return "Publish JMeter test result report";
        }

        public String getHelpFile() {
            return "/plugin/jmeter/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JMeterPublisher jmeterPublisher = new JMeterPublisher();
            req.bindParameters((Object)jmeterPublisher, "jmeter.");
            return jmeterPublisher;
        }
    }
}

