/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.jmeter.HttpSample;
import hudson.plugins.jmeter.JMeterReport;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriReport
implements ModelObject {
    private final JMeterReport jmeterReport;
    private final List<HttpSample> httpSampleList = new ArrayList<HttpSample>();
    private String uri;
    private final String staplerUri;

    UriReport(JMeterReport jmeterReport, String staplerUri, String uri) {
        this.jmeterReport = jmeterReport;
        this.staplerUri = staplerUri;
        this.setUri(uri);
    }

    public void addHttpSample(HttpSample httpSample) {
        this.httpSampleList.add(httpSample);
    }

    public int countErrors() {
        int nbError = 0;
        for (HttpSample currentSample : this.httpSampleList) {
            if (currentSample.isSuccessful()) continue;
            ++nbError;
        }
        return nbError;
    }

    public long getAverage() {
        long average = 0L;
        for (HttpSample currentSample : this.httpSampleList) {
            average += currentSample.getDuration();
        }
        return average / (long)this.size();
    }

    public AbstractBuild getBuild() {
        return this.jmeterReport.getBuild();
    }

    public List<HttpSample> getHttpSampleList() {
        return this.httpSampleList;
    }

    public long getMax() {
        return this.httpSampleList.get(this.size() - 1).getDuration();
    }

    public long getMin() {
        return this.httpSampleList.get(0).getDuration();
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isFailed() {
        return this.countErrors() != 0;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int size() {
        return this.httpSampleList.size();
    }

    public String getDisplayName() {
        return this.getUri();
    }

    public String getStaplerUri() {
        return this.staplerUri;
    }
}

