/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.jmeter.JMeterBuildAction;
import hudson.plugins.jmeter.JMeterReport;
import hudson.plugins.jmeter.UriReport;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JMeterReportMap
implements ModelObject {
    private transient JMeterBuildAction buildAction;
    private static final String JMETER_REPORTS_DIRECTORY = "jmeter-reports";
    private static final Logger logger = Logger.getLogger((String)JMeterReportMap.class.getName());
    private Map<String, JMeterReport> jmeterReportMap = new HashMap();

    JMeterReportMap() {
    }

    JMeterReportMap(JMeterBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    JMeterReportMap(JMeterBuildAction buildAction, List<File> pFileList) throws IOException {
        this.buildAction = buildAction;
        for (File pFile : pFileList) {
            this.jmeterReportMap.put(pFile.getName(), new JMeterReport(buildAction, pFile));
        }
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    JMeterBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return "JMeter";
    }

    public List<JMeterReport> getJmeterListOrdered() {
        Collection uriCollection = this.getJmeterReportMap().values();
        ArrayList<JMeterReport> listJmeter = new ArrayList<JMeterReport>(uriCollection.size());
        for (JMeterReport jMeterReport : uriCollection) {
            listJmeter.add(jMeterReport);
        }
        Collections.sort(listJmeter);
        return listJmeter;
    }

    public Map<String, JMeterReport> getJmeterReportMap() {
        return this.jmeterReportMap;
    }

    public JMeterReport getJmeterReport(String jmeterReportName) {
        JMeterReport meterReport = null;
        if (this.jmeterReportMap == null || this.jmeterReportMap.get(jmeterReportName) == null || this.jmeterReportMap.get(jmeterReportName) == null) {
            File reportFile = new File(this.getBuild().getRootDir(), JMeterReportMap.getJMeterReportFileRelativePath((String)jmeterReportName));
            try {
                meterReport = new JMeterReport(this.buildAction, reportFile);
                if (meterReport.size() == 0) {
                    logger.warn((Object)"jmeter report analysis is empty, ensure your jtl file is filled with samples.");
                }
                if (this.jmeterReportMap == null) {
                    this.jmeterReportMap = new HashMap();
                }
                this.jmeterReportMap.put(jmeterReportName, meterReport);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load " + reportFile), (Throwable)e);
                Throwable ex = e;
                do {
                    logger.warn((Object)ex.getLocalizedMessage());
                } while ((ex = ex.getCause()) != null);
            }
        } else {
            meterReport = (JMeterReport)this.jmeterReportMap.get(jmeterReportName);
        }
        return meterReport;
    }

    public UriReport getUriReport(String uriReport) {
        if (uriReport != null) {
            String uriReportDecoded;
            try {
                uriReportDecoded = URLDecoder.decode(uriReport.replace(UriReport.END_JMETER_PARAMETER, ""), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
            StringTokenizer st = new StringTokenizer(uriReportDecoded, ";");
            return (UriReport)((JMeterReport)this.getJmeterReportMap().get(st.nextToken())).getUriReportMap().get(st.nextToken());
        }
        return null;
    }

    public String getUrlName() {
        return "jmeterReportList";
    }

    void setBuildAction(JMeterBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setJmeterReportMap(Map<String, JMeterReport> jmeterReportMap) {
        this.jmeterReportMap = jmeterReportMap;
    }

    public static String getJMeterReportFileRelativePath(String reportFileName) {
        return JMeterReportMap.getRelativePath((String)reportFileName);
    }

    public static String getJMeterReportDirRelativePath() {
        return JMeterReportMap.getRelativePath(null);
    }

    private static String getRelativePath(String reportFileName) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("jmeter-reports");
        if (reportFileName != null) {
            sb.append("/").append(reportFileName);
        }
        return sb.toString();
    }

    public boolean isFailed(String jmeterReportName) {
        return this.getJmeterReport(jmeterReportName) == null;
    }
}

