/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.jmeter.HttpSample;
import hudson.plugins.jmeter.JMeterReport;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriReport
implements ModelObject,
Comparable<UriReport> {
    public static String END_JMETER_PARAMETER = ".endjmeterparameter";
    private final List<HttpSample> httpSampleList = new ArrayList();
    private final JMeterReport jmeterReport;
    private final String staplerUri;
    private String uri;

    UriReport(JMeterReport jmeterReport, String staplerUri, String uri) {
        this.jmeterReport = jmeterReport;
        this.staplerUri = staplerUri;
        this.setUri(uri);
    }

    public void addHttpSample(HttpSample httpSample) {
        this.httpSampleList.add(httpSample);
    }

    @Override
    public int compareTo(UriReport uriReport) {
        if (uriReport == this) {
            return 0;
        }
        return uriReport.getUri().compareTo(this.getUri());
    }

    public int countErrors() {
        int nbError = 0;
        for (HttpSample currentSample : this.httpSampleList) {
            if (currentSample.isSuccessful()) continue;
            ++nbError;
        }
        return nbError;
    }

    public long getAverage() {
        long average = 0L;
        for (HttpSample currentSample : this.httpSampleList) {
            average += currentSample.getDuration();
        }
        return average / (long)this.size();
    }

    public AbstractBuild getBuild() {
        return this.jmeterReport.getBuild();
    }

    public String getDisplayName() {
        return this.getUri();
    }

    public List<HttpSample> getHttpSampleList() {
        return this.httpSampleList;
    }

    public JMeterReport getJmeterReport() {
        return this.jmeterReport;
    }

    public long getMax() {
        long max = Long.MIN_VALUE;
        for (HttpSample currentSample : this.httpSampleList) {
            max = Math.max(max, currentSample.getDuration());
        }
        return max;
    }

    public long getMin() {
        long min = Long.MAX_VALUE;
        for (HttpSample currentSample : this.httpSampleList) {
            min = Math.min(min, currentSample.getDuration());
        }
        return min;
    }

    public String getStaplerUri() {
        return this.staplerUri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isFailed() {
        return this.countErrors() != 0;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int size() {
        return this.httpSampleList.size();
    }

    public String encodeUriReport() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.jmeterReport.getReportFileName()).append(";").append(this.getStaplerUri()).append(END_JMETER_PARAMETER);
        return URLEncoder.encode(sb.toString(), "UTF-8");
    }
}

