/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.jmeter.JMeterReportMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterBuildAction
implements Action,
StaplerProxy {
    private static final long serialVersionUID = 1L;
    private final AbstractBuild<?, ?> build;
    private final transient PrintStream hudsonConsoleWriter;
    private transient WeakReference<JMeterReportMap> jmeterReportMap;
    private static final Logger logger = Logger.getLogger((String)JMeterBuildAction.class.getName());

    public JMeterBuildAction(AbstractBuild<?, ?> pBuild, PrintStream logger) {
        this.build = pBuild;
        this.hudsonConsoleWriter = logger;
        this.jmeterReportMap = new WeakReference<JMeterReportMap>(new JMeterReportMap(this));
    }

    public String getDisplayName() {
        return "JMeter report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "jmeter";
    }

    public Object getTarget() {
        File repo = new File(this.build.getRootDir(), JMeterReportMap.getJMeterReportDirRelativePath());
        ArrayList<File> pFileList = new ArrayList<File>(0);
        for (File file : repo.listFiles()) {
            pFileList.add(file);
        }
        JMeterReportMap jmList = null;
        try {
            jmList = new JMeterReportMap(this, pFileList);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return jmList;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    PrintStream getHudsonConsoleWriter() {
        return this.hudsonConsoleWriter;
    }

    public WeakReference<JMeterReportMap> getJmeterReportMap() {
        if (this.jmeterReportMap == null || this.jmeterReportMap.get() == null) {
            JMeterReportMap reportMap = new JMeterReportMap(this);
            this.jmeterReportMap = new WeakReference<JMeterReportMap>(reportMap);
        }
        return this.jmeterReportMap;
    }

    public void setJmeterReportMap(WeakReference<JMeterReportMap> jmeterReportMap) {
        this.jmeterReportMap = jmeterReportMap;
    }
}

