/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.jmeter.GraphConfigurationDetail;
import hudson.plugins.jmeter.JMeterBuildAction;
import hudson.plugins.jmeter.JMeterReport;
import hudson.plugins.jmeter.JMeterReportMap;
import hudson.plugins.jmeter.JMeterReportPosition;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMeterProjectAction
implements Action {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JMeterProjectAction.class.getName());
    public final AbstractProject<?, ?> project;
    private transient List<String> jmeterReportList;

    public String getDisplayName() {
        return "JMeter trend";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "jmeter";
    }

    public JMeterProjectAction(AbstractProject project) {
        this.project = project;
    }

    private JFreeChart createErrorsChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)"Percentage of errors", null, (String)"%", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound(100.0);
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private JFreeChart createRespondingTimeChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)"Responding time", null, (String)"ms", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public void doErrorsGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        JMeterReportPosition jmeterReportPosition = new JMeterReportPosition();
        request.bindParameters((Object)jmeterReportPosition);
        String jmeterReportNameFile = jmeterReportPosition.getJmeterReportPosition();
        if (jmeterReportNameFile == null) {
            if (this.getJmeterReportList().size() == 1) {
                jmeterReportNameFile = this.getJmeterReportList().get(0);
            } else {
                return;
            }
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderErrors = new DataSetBuilder();
        List builds = this.getProject().getBuilds();
        List<Integer> buildsLimits = this.getFirstAndLastBuild(request, builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (nbBuildsToAnalyze <= buildsLimits.get(1) && buildsLimits.get(0) <= nbBuildsToAnalyze) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                JMeterBuildAction jmeterBuildAction = (JMeterBuildAction)currentBuild.getAction(JMeterBuildAction.class);
                if (jmeterBuildAction == null) continue;
                JMeterReport jmeterReport = null;
                jmeterReport = ((JMeterReportMap)jmeterBuildAction.getJmeterReportMap().get()).getJmeterReport(jmeterReportNameFile);
                if (jmeterReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSetBuilderErrors.add((Number)jmeterReport.errorPercent(), (Comparable)((Object)"errors"), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createErrorsChart(dataSetBuilderErrors.build()), (int)400, (int)200);
    }

    public void doRespondingTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        JMeterReportPosition jmeterReportPosition = new JMeterReportPosition();
        request.bindParameters((Object)jmeterReportPosition);
        String jmeterReportNameFile = jmeterReportPosition.getJmeterReportPosition();
        if (jmeterReportNameFile == null) {
            if (this.getJmeterReportList().size() == 1) {
                jmeterReportNameFile = this.getJmeterReportList().get(0);
            } else {
                return;
            }
        }
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dataSetBuilderAverage = new DataSetBuilder();
        List builds = this.getProject().getBuilds();
        List<Integer> buildsLimits = this.getFirstAndLastBuild(request, builds);
        int nbBuildsToAnalyze = builds.size();
        for (AbstractBuild currentBuild : builds) {
            if (nbBuildsToAnalyze <= buildsLimits.get(1) && buildsLimits.get(0) <= nbBuildsToAnalyze) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(currentBuild);
                JMeterBuildAction jmeterBuildAction = (JMeterBuildAction)currentBuild.getAction(JMeterBuildAction.class);
                if (jmeterBuildAction == null) continue;
                JMeterReport jmeterReport = null;
                jmeterReport = ((JMeterReportMap)jmeterBuildAction.getJmeterReportMap().get()).getJmeterReport(jmeterReportNameFile);
                if (jmeterReport == null) {
                    --nbBuildsToAnalyze;
                    continue;
                }
                dataSetBuilderAverage.add((Number)jmeterReport.getMax(), (Comparable)((Object)"max"), (Comparable)label);
                dataSetBuilderAverage.add((Number)jmeterReport.getAverage(), (Comparable)((Object)"average"), (Comparable)label);
                dataSetBuilderAverage.add((Number)jmeterReport.getMin(), (Comparable)((Object)"min"), (Comparable)label);
            }
            --nbBuildsToAnalyze;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createRespondingTimeChart(dataSetBuilderAverage.build()), (int)400, (int)200);
    }

    private List<Integer> getFirstAndLastBuild(StaplerRequest request, List<?> builds) {
        ArrayList<Integer> outList = new ArrayList<Integer>(2);
        GraphConfigurationDetail graphConf = (GraphConfigurationDetail)this.createUserConfiguration(request);
        String configType = graphConf.getConfigType();
        if (configType.compareToIgnoreCase("BUILD") == 0) {
            if (graphConf.getBuildCount() <= 0) {
                configType = "NONE";
            } else {
                if (builds.size() - graphConf.getBuildCount() > 0) {
                    outList.add(builds.size() - graphConf.getBuildCount() + 1);
                } else {
                    outList.add(1);
                }
                outList.add(builds.size());
            }
        } else if (configType.compareToIgnoreCase("DATE") == 0) {
            if ("dd/MM/yyyy".compareTo(graphConf.getFirstDayCount()) == 0 && "dd/MM/yyyy".compareTo(graphConf.getLastDayCount()) == 0) {
                configType = "NONE";
            } else {
                int firstBuild = -1;
                int lastBuild = -1;
                int var = builds.size();
                GregorianCalendar firstDate = null;
                GregorianCalendar lastDate = null;
                try {
                    firstDate = GraphConfigurationDetail.getGregorianCalendarFromString(graphConf.getFirstDayCount());
                    lastDate = GraphConfigurationDetail.getGregorianCalendarFromString(graphConf.getLastDayCount());
                    lastDate.set(11, 23);
                    lastDate.set(12, 59);
                    lastDate.set(13, 59);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.SEVERE, "Error during the manage of the Calendar", e);
                }
                for (AbstractBuild currentBuild : builds) {
                    GregorianCalendar buildDate = new GregorianCalendar();
                    buildDate.setTime(currentBuild.getTimestamp().getTime());
                    if (firstDate.getTime().before(buildDate.getTime())) {
                        firstBuild = var;
                    }
                    if (lastBuild < 0 && lastDate.getTime().after(buildDate.getTime())) {
                        lastBuild = var;
                    }
                    --var;
                }
                outList.add(firstBuild);
                outList.add(lastBuild);
            }
        }
        if (configType.compareToIgnoreCase("NONE") == 0) {
            outList.add(1);
            outList.add(builds.size());
        }
        return outList;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public List<String> getJmeterReportList() {
        File file;
        this.jmeterReportList = new ArrayList<String>(0);
        if (this.project != null && this.project.getSomeBuildWithWorkspace() != null && (file = new File(this.project.getSomeBuildWithWorkspace().getRootDir(), JMeterReportMap.getJMeterReportDirRelativePath())).exists()) {
            for (File jmeterReportFile : file.listFiles()) {
                this.jmeterReportList.add(jmeterReportFile.getName());
            }
        }
        if (this.jmeterReportList != null) {
            Collections.sort(this.jmeterReportList);
        }
        return this.jmeterReportList;
    }

    public void setJmeterReportList(List<String> jmeterReportList) {
        this.jmeterReportList = jmeterReportList;
    }

    public boolean isTrendVisibleOnProjectDashboard() {
        return this.getJmeterReportList() != null && this.getJmeterReportList().size() == 1;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if ("configure".equals(link)) {
            return this.createUserConfiguration(request);
        }
        return null;
    }

    private Object createUserConfiguration(StaplerRequest request) {
        GraphConfigurationDetail graph = new GraphConfigurationDetail(this.project, "jmeter", request);
        return graph;
    }
}

