/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jmeter;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.jmeter.JMeterBuildAction;
import hudson.plugins.jmeter.JMeterProjectAction;
import hudson.plugins.jmeter.JMeterReportMap;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterPublisher
extends Recorder {
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private String filename;

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public static File getJMeterReport(AbstractBuild<?, ?> build, String jmeterReportName) {
        return new File(build.getRootDir(), JMeterReportMap.getJMeterReportFileRelativePath(JMeterPublisher.getJMeterReportBuildFileName(jmeterReportName)));
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new JMeterProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static String getJMeterReportBuildFileName(String jmeterReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = jmeterReportWorkspaceName;
        if (jmeterReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(jmeterReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println("Recording JMeter reports " + this.getFilename());
        List<String> filenameList = this.manageFilename(this.filename);
        boolean result = true;
        JMeterBuildAction jmeterBuildAction = new JMeterBuildAction(build, logger);
        build.addAction((Action)jmeterBuildAction);
        for (String filename : filenameList) {
            if (filename.compareTo("") == 0) continue;
            FilePath src = build.getWorkspace().child(filename);
            if (!src.exists()) {
                if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                    return true;
                }
                build.setResult(Result.FAILURE);
                logger.println("JMeter file " + src + " not found. Has the report generated? Setting Build to " + build.getResult().toString());
                return true;
            }
            if (!src.isDirectory()) {
                result = result && this.manageOneJMeterReport(build, src, jmeterBuildAction, logger) != false;
                continue;
            }
            List listSrc = new ArrayList(0);
            listSrc = src.list();
            Boolean resultManage = true;
            ArrayList<String> jmeterReportListNameFile = new ArrayList<String>(listSrc.size());
            for (FilePath filePath : listSrc) {
                resultManage = resultManage != false && this.manageOneJMeterReport(build, filePath, jmeterBuildAction, logger) != false;
                jmeterReportListNameFile.add(JMeterPublisher.getJMeterReportBuildFileName(filePath.getName()));
            }
            result = result && resultManage != false;
        }
        return result;
    }

    private Boolean manageOneJMeterReport(AbstractBuild<?, ?> build, FilePath src, JMeterBuildAction jmeterBuildAction, PrintStream logger) throws IOException, InterruptedException {
        File localReport = JMeterPublisher.getJMeterReport(build, src.getName());
        if (!localReport.getParentFile().exists()) {
            localReport.getParentFile().mkdirs();
        }
        if (src.isDirectory()) {
            logger.println("File : " + src.getName() + " is a directory, ant not a JMeter Report");
            return true;
        }
        src.copyTo(new FilePath(localReport));
        if (((JMeterReportMap)jmeterBuildAction.getJmeterReportMap().get()).isFailed(JMeterPublisher.getJMeterReportBuildFileName(src.getName()))) {
            build.setResult(Result.UNSTABLE);
            logger.println("JMeter report analysis failed. Setting Build to " + build.getResult().toString());
            return true;
        }
        if (this.errorUnstableThreshold > 0 && this.errorUnstableThreshold < 100) {
            logger.println("JMeter's percentage error greater or equal than " + this.errorUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase());
        }
        if (this.errorFailedThreshold > 0 && this.errorFailedThreshold < 100) {
            logger.println("JMeter's percentage error greater or equal than " + this.errorFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase());
        }
        double errorPercent = ((JMeterReportMap)jmeterBuildAction.getJmeterReportMap().get()).getJmeterReport(JMeterPublisher.getJMeterReportBuildFileName(src.getName())).errorPercent();
        if (this.errorFailedThreshold > 0 && errorPercent >= (double)this.errorFailedThreshold) {
            build.setResult(Result.FAILURE);
        } else if (this.errorUnstableThreshold > 0 && errorPercent >= (double)this.errorUnstableThreshold && build.getResult() != Result.FAILURE) {
            build.setResult(Result.UNSTABLE);
        }
        logger.println("JMeter has reported a " + errorPercent + "% of errors running the tests. Setting Build to " + build.getResult().toString());
        return true;
    }

    private List<String> manageFilename(String filename) {
        StringTokenizer st = new StringTokenizer(filename, ";");
        ArrayList<String> filenameList = new ArrayList<String>(0);
        while (st.hasMoreTokens()) {
            filenameList.add(st.nextToken());
        }
        Collections.sort(filenameList);
        return filenameList;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JMeterPublisher.class);
        }

        public String getDisplayName() {
            return "Publish JMeter test result report";
        }

        public String getHelpFile() {
            return "/plugin/jmeter/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JMeterPublisher jmeterPublisher = new JMeterPublisher();
            req.bindParameters((Object)jmeterPublisher, "jmeter.");
            return jmeterPublisher;
        }
    }
}

