/*
 * Decompiled with CFR 0.152.
 */
package com.meyling.hudson.plugin.job_exporter;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExporterBuilder
extends Builder {
    @DataBoundConstructor
    public ExporterBuilder() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String prefix = "build.";
        Properties export = new Properties();
        try {
            System.out.println(Computer.currentComputer().getHostName());
            export.put(prefix + "hudson.version", StringUtils.defaultString((String)build.getHudsonVersion()));
            export.put(prefix + "id", StringUtils.defaultString((String)build.getId()));
            Executor executor = build.getExecutor();
            if (executor != null) {
                export.put(prefix + "summary", StringUtils.defaultString((String)build.getExecutor().getName()));
            }
            export.put(prefix + "number", "" + build.getNumber());
            EnvVars env = build.getEnvironment((TaskListener)new LogTaskListener(Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.INFO));
            if (env != null) {
                export.put(prefix + "jobName", StringUtils.defaultString((String)((String)env.get((Object)"JOB_NAME"))));
                export.put(prefix + "cvsBranch", StringUtils.defaultString((String)((String)env.get((Object)"CVS_BRANCH"))));
            }
            this.log(listener.getLogger(), "exporting properties");
            Mailer.DescriptorImpl descriptor = (Mailer.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Mailer.DescriptorImpl.class);
            export.put(prefix + "admin.emailAddress", descriptor.getAdminAddress());
            export.put(prefix + "user.emailAddress", descriptor.getAdminAddress());
            List cal = build.getActions(CauseAction.class);
            for (CauseAction ca : cal) {
                this.log(listener.getLogger(), ca.getDisplayName());
                this.log(listener.getLogger(), ca.toString());
                List cl = ca.getCauses();
                for (Cause c : cl) {
                    if (!(c instanceof Cause.UserCause)) continue;
                    Cause.UserCause uc = (Cause.UserCause)c;
                    export.put(prefix + "user.name", StringUtils.defaultString((String)uc.getUserName()));
                    User u = User.get((String)uc.getUserName());
                    export.put(prefix + "user.fullName", StringUtils.defaultString((String)u.getFullName()));
                    Mailer.UserProperty umail = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class);
                    String email = StringUtils.defaultString((String)umail.getAddress()).trim();
                    if (email.length() <= 0) continue;
                    export.put(prefix + "user.emailAddress", email);
                }
            }
            FilePath ws = build.getProject().getWorkspace();
            FilePath hudson = ws.child("hudsonBuild.properties");
            if (hudson.exists()) {
                if (!hudson.delete()) {
                    this.log(listener.getLogger(), "old file can not be deleted: " + hudson);
                    build.setResult(Result.FAILURE);
                    return false;
                }
                this.log(listener.getLogger(), "old file deleted: " + hudson);
            }
            OutputStream out = hudson.write();
            export.store(out, "created by " + ((Object)((Object)this)).getClass().getName());
            out.close();
            this.log(listener.getLogger(), "new properties file written: " + hudson);
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("failed to read or write property file"));
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error("failed to read or write property file"));
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    protected void log(PrintStream logger, String message) {
        logger.println("[exporter] " + StringUtils.defaultString((String)message));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Export job runtime parameters";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.save();
            return super.configure(req, o);
        }
    }
}

