/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildTrigger;
import java.util.LinkedList;
import java.util.List;
import join.JoinAction;
import join.JoinTrigger;

public class JoinAction
implements Action {
    private List<String> pendingDownstreamProjects;
    private List<String> completedDownstreamProjects;
    private String joinProjects;
    private boolean evenIfDownstreamUnstable;
    private Result overallResult;

    public JoinAction(JoinTrigger joinTrigger, BuildTrigger buildTrigger) {
        String[] split = buildTrigger == null ? new String[]{} : buildTrigger.getChildProjectsValue().split(",");
        this.pendingDownstreamProjects = new LinkedList();
        for (String proj : split) {
            this.pendingDownstreamProjects.add(proj.trim());
        }
        this.joinProjects = joinTrigger.getJoinProjectsValue();
        this.evenIfDownstreamUnstable = joinTrigger.getEvenIfDownstreamUnstable();
        this.completedDownstreamProjects = new LinkedList();
        this.overallResult = Result.SUCCESS;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "join";
    }

    public void downstreamFinished(String name, Run r, TaskListener listener) {
        if (this.pendingDownstreamProjects.remove(name)) {
            this.overallResult = this.overallResult.combine(r.getResult());
            this.completedDownstreamProjects.add(name);
            this.checkPendingDownstream(r, listener);
        }
    }

    public void checkPendingDownstream(Run r, TaskListener listener) {
        if (this.pendingDownstreamProjects.isEmpty()) {
            Result threshold;
            listener.getLogger().println("All downstream projects complete!");
            Result result = threshold = this.evenIfDownstreamUnstable ? Result.UNSTABLE : Result.SUCCESS;
            if (this.overallResult.isWorseThan(threshold)) {
                listener.getLogger().println("Minimum result threshold not met for join project");
            } else {
                List projects = Items.fromNameList((String)this.joinProjects, AbstractProject.class);
                for (AbstractProject project : projects) {
                    listener.getLogger().println("Scheduling join project: " + project.getName());
                    project.scheduleBuild((Cause)new JoinCause(this, r));
                }
            }
        }
    }
}

