/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import join.JoinAction;
import join.JoinTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAction
implements Action {
    private List<String> pendingDownstreamProjects;
    private List<String> completedDownstreamProjects;
    private transient String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers;
    private boolean evenIfDownstreamUnstable;
    private Result overallResult;

    public JoinAction(JoinTrigger joinTrigger, BuildTrigger buildTrigger, ArrayList<String> otherDownstream) {
        String[] downstreamProjects = buildTrigger == null ? new String[]{} : buildTrigger.getChildProjectsValue().split(",");
        this.pendingDownstreamProjects = new LinkedList();
        for (String proj : otherDownstream) {
            this.pendingDownstreamProjects.add(proj.trim());
        }
        for (String proj : downstreamProjects) {
            this.pendingDownstreamProjects.add(proj.trim());
        }
        this.joinProjects = joinTrigger.getJoinProjectsValue();
        this.joinPublishers = joinTrigger.getJoinPublishers();
        this.evenIfDownstreamUnstable = joinTrigger.getEvenIfDownstreamUnstable();
        this.completedDownstreamProjects = new LinkedList();
        this.overallResult = Result.SUCCESS;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "join";
    }

    public void downstreamFinished(AbstractBuild<?, ?> upstreamBuild, AbstractBuild<?, ?> finishedBuild, TaskListener listener) {
        String finishedBuildProjectName = finishedBuild.getProject().getName();
        if (this.pendingDownstreamProjects.remove(finishedBuildProjectName)) {
            this.overallResult = this.overallResult.combine(finishedBuild.getResult());
            this.completedDownstreamProjects.add(finishedBuildProjectName);
            this.checkPendingDownstream(upstreamBuild, listener);
        } else {
            listener.getLogger().println("[Join] Pending does not contain " + finishedBuildProjectName);
        }
    }

    public void checkPendingDownstream(AbstractBuild<?, ?> owner, TaskListener listener) {
        if (this.pendingDownstreamProjects.isEmpty()) {
            Result threshold;
            listener.getLogger().println("All downstream projects complete!");
            Result result = threshold = this.evenIfDownstreamUnstable ? Result.UNSTABLE : Result.SUCCESS;
            if (this.overallResult.isWorseThan(threshold)) {
                listener.getLogger().println("Minimum result threshold not met for join project");
            } else {
                for (Publisher pub : this.joinPublishers) {
                    try {
                        pub.perform(owner, null, (BuildListener)listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                List projects = Items.fromNameList((String)this.joinProjects, AbstractProject.class);
                for (AbstractProject project : projects) {
                    listener.getLogger().println("Scheduling join project: " + project.getName());
                    project.scheduleBuild((Cause)new JoinCause(this, owner));
                }
            }
        } else {
            listener.getLogger().println("Project " + owner.getProject().getName() + " still waiting for " + this.pendingDownstreamProjects.size() + " builds to complete");
        }
    }
}

