/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.Launcher;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import join.JoinAction;
import join.JoinTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTrigger
extends Recorder {
    private String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers = new DescribableList((Saveable)null);
    private boolean evenIfDownstreamUnstable;
    private static final Logger LOGGER = Logger.getLogger(JoinTrigger.class.getName());

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher bs : this.joinPublishers) {
            if (bs.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)build.getProject().getPublishersList().get(hudson.tasks.BuildTrigger.class);
        JoinAction joinAction = new JoinAction(this, buildTrigger, this.TryGetParameterizedDownstreamNames(build));
        build.addAction((Action)joinAction);
        joinAction.checkPendingDownstream(build, (TaskListener)listener);
        return true;
    }

    private ArrayList<String> TryGetParameterizedDownstreamNames(AbstractBuild<?, ?> build) {
        BuildTrigger buildTrigger;
        ArrayList<String> ret = new ArrayList<String>();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                for (AbstractProject project : config.getProjectList()) {
                    ret.add(project.getName());
                }
            }
        }
        return ret;
    }

    public JoinTrigger() {
        this(new DescribableList((Saveable)null), "", false);
    }

    public JoinTrigger(DescribableList<Publisher, Descriptor<Publisher>> publishers, String string, boolean b) {
        this.joinProjects = string;
        this.evenIfDownstreamUnstable = b;
        this.joinPublishers = publishers;
    }

    public boolean usePostBuildActions() {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableDescriptors());
    }

    private boolean containsAnyDescriptor(List<Descriptor<Publisher>> applicableDescriptors) {
        for (Descriptor<Publisher> descriptor : applicableDescriptors) {
            if (!this.joinPublishers.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean useExperimentalPostBuildActions(AbstractProject<?, ?> project) {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableExperimentalDescriptors(project));
    }

    public String getJoinProjectsValue() {
        return this.joinProjects;
    }

    public List<AbstractProject> getJoinProjects() {
        return Items.fromNameList((String)this.joinProjects, AbstractProject.class);
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getJoinPublishers() {
        return this.joinPublishers;
    }

    public boolean getEvenIfDownstreamUnstable() {
        return this.evenIfDownstreamUnstable;
    }

    private Object readResolve() {
        if (this.joinPublishers == null) {
            this.joinPublishers = new DescribableList((Saveable)null);
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

