/*
 * Decompiled with CFR 0.152.
 */
package join;

import com.thalesgroup.hudson.plugins.copyarchiver.CopyArchiverPublisher;
import hudson.Functions;
import hudson.Launcher;
import hudson.Plugin;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import join.JoinAction;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTrigger
extends Recorder {
    private String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers = new DescribableList((Saveable)null);
    private boolean evenIfDownstreamUnstable;
    private static final Logger LOGGER = Logger.getLogger(JoinTrigger.class.getName());

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher bs : this.joinPublishers) {
            if (bs.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)build.getProject().getPublishersList().get(hudson.tasks.BuildTrigger.class);
        JoinAction joinAction = new JoinAction(this, buildTrigger, this.TryGetParameterizedDownstreamNames(build));
        build.addAction((Action)joinAction);
        joinAction.checkPendingDownstream(build, (TaskListener)listener);
        return true;
    }

    private ArrayList<String> TryGetParameterizedDownstreamNames(AbstractBuild<?, ?> build) {
        BuildTrigger buildTrigger;
        ArrayList<String> ret = new ArrayList<String>();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                for (AbstractProject project : config.getProjectList()) {
                    ret.add(project.getName());
                }
            }
        }
        return ret;
    }

    public JoinTrigger() {
        this((DescribableList<Publisher, Descriptor<Publisher>>)new DescribableList((Saveable)null), "", false);
    }

    public JoinTrigger(DescribableList<Publisher, Descriptor<Publisher>> publishers, String string, boolean b) {
        this.joinProjects = string;
        this.evenIfDownstreamUnstable = b;
        this.joinPublishers = publishers;
    }

    public boolean usePostBuildActions() {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableDescriptors());
    }

    private boolean containsAnyDescriptor(List<Descriptor<Publisher>> applicableDescriptors) {
        for (Descriptor<Publisher> descriptor : applicableDescriptors) {
            if (!this.joinPublishers.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean useExperimentalPostBuildActions(AbstractProject<?, ?> project) {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableExperimentalDescriptors(project));
    }

    public String getJoinProjectsValue() {
        return this.joinProjects;
    }

    public List<AbstractProject> getJoinProjects() {
        return Items.fromNameList((String)this.joinProjects, AbstractProject.class);
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getJoinPublishers() {
        return this.joinPublishers;
    }

    public boolean getEvenIfDownstreamUnstable() {
        return this.evenIfDownstreamUnstable;
    }

    private Object readResolve() {
        if (this.joinPublishers == null) {
            this.joinPublishers = new DescribableList((Saveable)null);
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        public String getDisplayName() {
            return "Join Trigger";
        }

        public String getHelpFile() {
            return "/plugin/join/help/joinTrigger.html";
        }

        public JoinTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject joinTriggers;
            JSONObject experimentalpostbuild;
            JSONObject joinPublishers;
            LOGGER.finer(formData.toString());
            DescribableList publishers = new DescribableList((Saveable)null);
            JSONObject postbuild = formData.optJSONObject("postbuildactions");
            if (postbuild != null && (joinPublishers = postbuild.optJSONObject("joinPublishers")) != null) {
                publishers.rebuild(req, joinPublishers, this.getApplicableDescriptors());
            }
            if ((experimentalpostbuild = formData.optJSONObject("experimentalpostbuildactions")) != null && (joinTriggers = experimentalpostbuild.optJSONObject("joinPublishers")) != null) {
                LOGGER.finest("EPB: " + joinTriggers.toString() + joinTriggers.isArray());
                publishers.rebuild(req, joinTriggers, (List)Publisher.all());
            }
            LOGGER.finer("Parsed " + publishers.size() + " publishers");
            return new JoinTrigger((DescribableList<Publisher, Descriptor<Publisher>>)publishers, formData.getString("joinProjectsValue"), formData.has("evenIfDownstreamUnstable") && formData.getBoolean("evenIfDownstreamUnstable"));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            boolean freeStyle = FreeStyleProject.class.isAssignableFrom(jobType);
            if (freeStyle) {
                return true;
            }
            Plugin mavenProjectPlugin = Hudson.getInstance().getPlugin("maven-plugin");
            return mavenProjectPlugin != null && AbstractMavenProject.class.isAssignableFrom(jobType);
        }

        public boolean showEvenIfUnstableOption(Class<? extends AbstractProject> jobType) {
            return !jobType.getName().contains("PromotionProcess");
        }

        public List<Descriptor<Publisher>> getApplicableDescriptors() {
            Plugin copyArchiver;
            ArrayList<Descriptor<Publisher>> list = new ArrayList<Descriptor<Publisher>>();
            Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
            if (parameterizedTrigger != null) {
                list.add(Hudson.getInstance().getDescriptorByType(BuildTrigger.DescriptorImpl.class));
            }
            if ((copyArchiver = Hudson.getInstance().getPlugin("copyarchiver")) != null) {
                list.add((Descriptor<Publisher>)Hudson.getInstance().getDescriptorByType(CopyArchiverPublisher.CopyArchiverDescriptor.class));
            }
            return list;
        }

        public List<Descriptor<Publisher>> getApplicableExperimentalDescriptors(AbstractProject<?, ?> project) {
            List list = Functions.getPublisherDescriptors(project);
            LOGGER.finest("publisher count before removing publishers: " + list.size());
            list.remove(Hudson.getInstance().getDescriptorByType(DescriptorImpl.class));
            list.removeAll(this.getApplicableDescriptors());
            LOGGER.finest("publisher count after removing publishers: " + list.size());
            return list;
        }

        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    hudson.tasks.BuildTrigger t = (hudson.tasks.BuildTrigger)p.getPublishersList().get(hudson.tasks.BuildTrigger.class);
                    if (t == null || !t.onJobRenamed(oldName, newName)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class RunListenerImpl
        extends RunListener<Run> {
            public RunListenerImpl() {
                super(Run.class);
            }

            public void onCompleted(Run run, TaskListener listener) {
                if (!(run instanceof AbstractBuild)) {
                    return;
                }
                AbstractBuild abstractBuild = (AbstractBuild)run;
                listener.getLogger().println("Notifying upstream projects of job completion");
                Object upstreamProject = null;
                boolean upstreamJobNumber = false;
                CauseAction ca = (CauseAction)run.getAction(CauseAction.class);
                if (ca == null) {
                    listener.getLogger().println("Join notifier requires a CauseAction");
                    return;
                }
                for (Cause c : ca.getCauses()) {
                    if (!(c instanceof Cause.UpstreamCause) || c instanceof JoinAction.JoinCause) continue;
                    Cause.UpstreamCause uc = (Cause.UpstreamCause)c;
                    this.notifyJob(abstractBuild, listener, uc.getUpstreamProject(), uc.getUpstreamBuild());
                }
            }

            private void notifyJob(AbstractBuild<?, ?> abstractBuild, TaskListener listener, String upstreamProjectName, int upstreamJobNumber) {
                List upstreamList = Items.fromNameList((String)upstreamProjectName, AbstractProject.class);
                if (upstreamList.size() != 1) {
                    listener.getLogger().println("Join notifier cannot find upstream project: " + upstreamProjectName);
                    return;
                }
                AbstractProject upstreamProject = (AbstractProject)upstreamList.get(0);
                Run upstreamRun = upstreamProject.getBuildByNumber(upstreamJobNumber);
                if (upstreamRun == null) {
                    listener.getLogger().println("Join notifier cannot find upstream run: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                if (!(upstreamRun instanceof AbstractBuild)) {
                    LOGGER.fine("Upstream run is not an AbstractBuild: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                AbstractBuild upstreamBuild = (AbstractBuild)upstreamRun;
                JoinAction ja = (JoinAction)upstreamRun.getAction(JoinAction.class);
                if (ja == null) {
                    LOGGER.finer("Join notifier cannot find upstream JoinAction: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                listener.getLogger().println("Notifying upstream of completion: " + upstreamProjectName + " #" + upstreamJobNumber);
                ja.downstreamFinished(upstreamBuild, abstractBuild, listener);
            }
        }
    }
}

