/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildTrigger;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import join.JoinAction;
import join.JoinTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAction
implements Action {
    private List<String> pendingDownstreamProjects = new LinkedList();
    private List<String> completedDownstreamProjects;
    private List<String> consideredBuilds;
    private transient String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers;
    private boolean evenIfDownstreamUnstable;
    private Result overallResult;

    public JoinAction(JoinTrigger joinTrigger, BuildTrigger buildTrigger, ArrayList<String> otherDownstream) {
        if (buildTrigger != null) {
            for (AbstractProject project : buildTrigger.getChildProjects()) {
                if (project.isDisabled()) continue;
                this.pendingDownstreamProjects.add(project.getName());
            }
        }
        for (String proj : otherDownstream) {
            this.pendingDownstreamProjects.add(proj.trim());
        }
        this.joinProjects = joinTrigger.getJoinProjectsValue();
        this.joinPublishers = joinTrigger.getJoinPublishers();
        this.evenIfDownstreamUnstable = joinTrigger.getEvenIfDownstreamUnstable();
        this.completedDownstreamProjects = new LinkedList();
        this.consideredBuilds = new LinkedList();
        this.overallResult = Result.SUCCESS;
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "join";
    }

    public synchronized boolean downstreamFinished(AbstractBuild<?, ?> upstreamBuild, AbstractBuild<?, ?> finishedBuild, TaskListener listener) {
        if (!this.consideredBuilds.contains(finishedBuild.toString())) {
            this.consideredBuilds.add(finishedBuild.toString());
            String finishedBuildProjectName = finishedBuild.getProject().getName();
            if (this.pendingDownstreamProjects.remove(finishedBuildProjectName)) {
                this.overallResult = this.overallResult.combine(finishedBuild.getResult());
                this.completedDownstreamProjects.add(finishedBuildProjectName);
                this.checkPendingDownstream(upstreamBuild, listener);
            } else {
                listener.getLogger().println("[Join] Pending does not contain " + finishedBuildProjectName);
            }
        }
        return this.pendingDownstreamProjects.isEmpty();
    }

    public Result getOverallResult() {
        return this.overallResult;
    }

    public synchronized void checkPendingDownstream(AbstractBuild<?, ?> owner, TaskListener listener) {
        if (this.pendingDownstreamProjects.isEmpty()) {
            Result threshold;
            listener.getLogger().println("All downstream projects complete!");
            Result result = threshold = this.evenIfDownstreamUnstable ? Result.UNSTABLE : Result.SUCCESS;
            if (this.overallResult.isWorseThan(threshold)) {
                listener.getLogger().println("Minimum result threshold not met for join project");
            } else {
                NoopLauncher launcher = new NoopLauncher(listener, owner);
                for (Publisher pub : this.joinPublishers) {
                    try {
                        pub.perform(owner, (Launcher)launcher, (BuildListener)listener);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!JoinTrigger.canDeclare((AbstractProject)owner.getProject())) {
                    List projects = Items.fromNameList((String)this.joinProjects, AbstractProject.class);
                    for (AbstractProject project : projects) {
                        listener.getLogger().println("Scheduling join project: " + project.getName());
                        project.scheduleBuild((Cause)new JoinCause(this, owner));
                    }
                }
            }
        } else {
            listener.getLogger().println("Project " + owner.getProject().getName() + " still waiting for " + this.pendingDownstreamProjects.size() + " builds to complete");
        }
    }
}

