/*
 * Decompiled with CFR 0.152.
 */
package join;

import hudson.Extension;
import hudson.Launcher;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import join.JoinAction;
import join.JoinTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Extension
public class JoinTrigger
extends Recorder
implements DependecyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(JoinTrigger.class.getName());
    private String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers = new DescribableList(Saveable.NOOP);
    private boolean evenIfDownstreamUnstable;

    public JoinTrigger() {
        this(new DescribableList(Saveable.NOOP), "", false);
    }

    public JoinTrigger(DescribableList<Publisher, Descriptor<Publisher>> publishers, String string, boolean b) {
        this.joinProjects = string;
        this.evenIfDownstreamUnstable = b;
        this.joinPublishers = publishers;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher bs : this.joinPublishers) {
            if (bs.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)build.getProject().getPublishersList().get(hudson.tasks.BuildTrigger.class);
        JoinAction joinAction = new JoinAction(this, buildTrigger, this.tryGetParameterizedDownstreamNames(build));
        build.addAction((Action)joinAction);
        joinAction.checkPendingDownstream(build, (TaskListener)listener);
        return true;
    }

    private ArrayList<String> tryGetParameterizedDownstreamNames(AbstractBuild<?, ?> build) {
        BuildTrigger buildTrigger;
        ArrayList<String> ret = new ArrayList<String>();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                for (AbstractProject project : config.getProjectList()) {
                    if (project.isDisabled()) continue;
                    ret.add(project.getName());
                }
            }
        }
        return ret;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!JoinTrigger.canDeclare((AbstractProject)owner)) {
            return;
        }
        List downstreamProjects = this.getAllDownstream(owner);
        if (downstreamProjects.isEmpty()) {
            downstreamProjects.add(owner);
        }
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        for (AbstractProject downstreamProject : downstreamProjects) {
            BuildTrigger paramBt;
            if (parameterizedTrigger != null && (paramBt = (BuildTrigger)this.joinPublishers.get(BuildTrigger.class)) != null) {
                for (BuildTriggerConfig config : paramBt.getConfigs()) {
                    for (AbstractProject joinProject : config.getProjectList()) {
                        ParameterizedJoinDependency dependency = new ParameterizedJoinDependency(downstreamProject, joinProject, owner, config, null);
                        graph.addDependency((DependencyGraph.Dependency)dependency);
                    }
                }
            }
            for (AbstractProject joinProject : this.getJoinProjects()) {
                JoinTriggerDependency dependency = new JoinTriggerDependency(downstreamProject, joinProject, owner, this.evenIfDownstreamUnstable);
                graph.addDependency((DependencyGraph.Dependency)dependency);
            }
        }
    }

    static boolean canDeclare(AbstractProject<?, ?> owner) {
        return DependencyGraph.class.getClasses().length > 0 && !owner.getClass().getName().equals("hudson.maven.MavenModuleSet");
    }

    public List<AbstractProject<?, ?>> getAllDownstream(AbstractProject<?, ?> project) {
        List downstream = this.getBuildTriggerDownstream(project);
        downstream.addAll(this.getParameterizedDownstream(project));
        return downstream;
    }

    public List<AbstractProject<?, ?>> getParameterizedDownstream(AbstractProject<?, ?> project) {
        BuildTrigger buildTrigger;
        ArrayList ret = new ArrayList();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)project.getPublishersList().get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                for (AbstractProject downStreamProject : config.getProjectList()) {
                    ret.add(downStreamProject);
                }
            }
        }
        return ret;
    }

    public List<AbstractProject<?, ?>> getBuildTriggerDownstream(AbstractProject<?, ?> project) {
        ArrayList ret = new ArrayList();
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)project.getPublishersList().get(hudson.tasks.BuildTrigger.class);
        if (buildTrigger != null) {
            for (AbstractProject childProject : buildTrigger.getChildProjects()) {
                ret.add(childProject);
            }
        }
        return ret;
    }

    public boolean usePostBuildActions() {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableDescriptors());
    }

    private boolean containsAnyDescriptor(List<Descriptor<Publisher>> applicableDescriptors) {
        for (Descriptor<Publisher> descriptor : applicableDescriptors) {
            if (!this.joinPublishers.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean useExperimentalPostBuildActions(AbstractProject<?, ?> project) {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableExperimentalDescriptors(project));
    }

    public String getJoinProjectsValue() {
        return this.joinProjects;
    }

    public List<AbstractProject> getJoinProjects() {
        List list = this.joinProjects == null ? new ArrayList() : Items.fromNameList((String)this.joinProjects, AbstractProject.class);
        return list;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getJoinPublishers() {
        return this.joinPublishers;
    }

    public boolean getEvenIfDownstreamUnstable() {
        return this.evenIfDownstreamUnstable;
    }

    private Object readResolve() {
        if (this.joinPublishers == null) {
            this.joinPublishers = new DescribableList(Saveable.NOOP);
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

