/*
 * Decompiled with CFR 0.152.
 */
package join;

import com.thalesgroup.hudson.plugins.copyarchiver.CopyArchiverPublisher;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Plugin;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import join.JoinAction;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JoinTrigger
extends Recorder
implements DependecyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(JoinTrigger.class.getName());
    private String joinProjects;
    private DescribableList<Publisher, Descriptor<Publisher>> joinPublishers = new DescribableList(Saveable.NOOP);
    private boolean evenIfDownstreamUnstable;

    public JoinTrigger() {
        this((DescribableList<Publisher, Descriptor<Publisher>>)new DescribableList(Saveable.NOOP), "", false);
    }

    public JoinTrigger(DescribableList<Publisher, Descriptor<Publisher>> publishers, String string, boolean b) {
        this.joinProjects = string;
        this.evenIfDownstreamUnstable = b;
        this.joinPublishers = publishers;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher bs : this.joinPublishers) {
            if (bs.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)build.getProject().getPublishersList().get(hudson.tasks.BuildTrigger.class);
        JoinAction joinAction = new JoinAction(this, buildTrigger, this.tryGetParameterizedDownstreamNames(build));
        build.addAction((Action)joinAction);
        joinAction.checkPendingDownstream(build, (TaskListener)listener);
        return true;
    }

    private ArrayList<String> tryGetParameterizedDownstreamNames(AbstractBuild<?, ?> build) {
        BuildTrigger buildTrigger;
        ArrayList<String> ret = new ArrayList<String>();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)build.getProject().getPublishersList().get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                for (AbstractProject project : config.getProjectList()) {
                    if (project.isDisabled()) continue;
                    ret.add(project.getName());
                }
            }
        }
        return ret;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!JoinTrigger.canDeclare(owner)) {
            return;
        }
        List<AbstractProject<?, ?>> downstreamProjects = this.getAllDownstream(owner);
        if (downstreamProjects.isEmpty()) {
            downstreamProjects.add(owner);
        }
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        for (AbstractProject<?, ?> downstreamProject : downstreamProjects) {
            BuildTrigger paramBt;
            if (parameterizedTrigger != null && (paramBt = (BuildTrigger)this.joinPublishers.get(BuildTrigger.class)) != null) {
                for (BuildTriggerConfig config : paramBt.getConfigs()) {
                    for (AbstractProject joinProject : config.getProjectList()) {
                        ParameterizedJoinDependency dependency = new ParameterizedJoinDependency(downstreamProject, joinProject, owner, config);
                        graph.addDependency((DependencyGraph.Dependency)dependency);
                    }
                }
            }
            for (AbstractProject joinProject : this.getJoinProjects()) {
                JoinTriggerDependency dependency = new JoinTriggerDependency(downstreamProject, joinProject, owner, this.evenIfDownstreamUnstable);
                graph.addDependency((DependencyGraph.Dependency)dependency);
            }
        }
    }

    static boolean canDeclare(AbstractProject<?, ?> owner) {
        return DependencyGraph.class.getClasses().length > 0 && !owner.getClass().getName().equals("hudson.maven.MavenModuleSet");
    }

    public List<AbstractProject<?, ?>> getAllDownstream(AbstractProject<?, ?> project) {
        List<AbstractProject<?, ?>> downstream = this.getBuildTriggerDownstream(project);
        downstream.addAll(this.getParameterizedDownstream(project));
        return downstream;
    }

    public List<AbstractProject<?, ?>> getParameterizedDownstream(AbstractProject<?, ?> project) {
        BuildTrigger buildTrigger;
        ArrayList ret = new ArrayList();
        Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
        if (parameterizedTrigger != null && (buildTrigger = (BuildTrigger)project.getPublishersList().get(BuildTrigger.class)) != null) {
            for (BuildTriggerConfig config : buildTrigger.getConfigs()) {
                for (AbstractProject downStreamProject : config.getProjectList()) {
                    ret.add(downStreamProject);
                }
            }
        }
        return ret;
    }

    public List<AbstractProject<?, ?>> getBuildTriggerDownstream(AbstractProject<?, ?> project) {
        ArrayList ret = new ArrayList();
        hudson.tasks.BuildTrigger buildTrigger = (hudson.tasks.BuildTrigger)project.getPublishersList().get(hudson.tasks.BuildTrigger.class);
        if (buildTrigger != null) {
            for (AbstractProject childProject : buildTrigger.getChildProjects()) {
                ret.add(childProject);
            }
        }
        return ret;
    }

    public boolean usePostBuildActions() {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableDescriptors());
    }

    private boolean containsAnyDescriptor(List<Descriptor<Publisher>> applicableDescriptors) {
        for (Descriptor<Publisher> descriptor : applicableDescriptors) {
            if (!this.joinPublishers.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean useExperimentalPostBuildActions(AbstractProject<?, ?> project) {
        return this.containsAnyDescriptor(DescriptorImpl.DESCRIPTOR.getApplicableExperimentalDescriptors(project));
    }

    public String getJoinProjectsValue() {
        return this.joinProjects;
    }

    public List<AbstractProject> getJoinProjects() {
        List list = this.joinProjects == null ? new ArrayList() : Items.fromNameList((String)this.joinProjects, AbstractProject.class);
        return list;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getJoinPublishers() {
        return this.joinPublishers;
    }

    public boolean getEvenIfDownstreamUnstable() {
        return this.evenIfDownstreamUnstable;
    }

    private Object readResolve() {
        if (this.joinPublishers == null) {
            this.joinPublishers = new DescribableList(Saveable.NOOP);
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JoinTriggerDependency
    extends JoinDependency<DependencyGraph.Dependency> {
        boolean evenIfDownstreamUnstable;

        JoinTriggerDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, AbstractProject<?, ?> splitProject, boolean evenIfDownstreamUnstable) {
            super(upstream, downstream, splitProject);
            this.evenIfDownstreamUnstable = evenIfDownstreamUnstable;
            this.splitDependency = new DependencyGraph.Dependency(splitProject, downstream);
        }

        @Override
        protected boolean conditionIsMet(Result overallResult) {
            Result threshold = this.evenIfDownstreamUnstable ? Result.UNSTABLE : Result.SUCCESS;
            return overallResult.isBetterOrEqualTo(threshold);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            JoinTriggerDependency other = (JoinTriggerDependency)((Object)obj);
            return this.evenIfDownstreamUnstable == other.evenIfDownstreamUnstable;
        }

        @Override
        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + super.hashCode();
            hash = 71 * hash + (this.evenIfDownstreamUnstable ? 1 : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterizedJoinDependency
    extends JoinDependency<ParameterizedDependency> {
        private BuildTriggerConfig config;

        private ParameterizedJoinDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, AbstractProject<?, ?> splitProject, BuildTriggerConfig config) {
            super(upstream, downstream, splitProject);
            this.splitDependency = new ParameterizedDependency(splitProject, downstream, config);
            this.config = config;
        }

        @Override
        protected boolean conditionIsMet(Result overallResult) {
            try {
                ResultCondition condition = this.config.getCondition();
                Method isMetMethod = condition.getClass().getDeclaredMethod("isMet", Result.class);
                isMetMethod.setAccessible(true);
                return (Boolean)isMetMethod.invoke((Object)condition, overallResult);
            }
            catch (Exception ex) {
                Logger.getLogger(ParameterizedJoinDependency.class.getName()).log(Level.SEVERE, null, ex);
                return true;
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ParameterizedJoinDependency other = (ParameterizedJoinDependency)((Object)obj);
            return this.config == other.config || this.config != null && this.config.equals(other.config);
        }

        @Override
        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + super.hashCode();
            hash = 61 * hash + (this.config != null ? this.config.hashCode() : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JoinDependency<DEP extends DependencyGraph.Dependency>
    extends DependencyGraph.Dependency {
        private AbstractProject<?, ?> splitProject;
        protected DEP splitDependency;

        protected JoinDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream, AbstractProject<?, ?> splitProject) {
            super(upstream, downstream);
            this.splitProject = splitProject;
        }

        public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
            JoinAction joinAction;
            AbstractBuild<?, ?> splitBuild = this.getSplitBuild(build);
            if (splitBuild != null && (joinAction = (JoinAction)splitBuild.getAction(JoinAction.class)) != null) {
                listener.getLogger().println("Notifying upstream build " + splitBuild + " of job completion");
                boolean joinDownstreamFinished = joinAction.downstreamFinished(splitBuild, build, listener);
                joinDownstreamFinished = joinDownstreamFinished && this.conditionIsMet(joinAction.getOverallResult()) && this.splitDependency.shouldTriggerBuild(splitBuild, listener, actions);
                return joinDownstreamFinished;
            }
            LOGGER.log(Level.FINER, "Join notifier cannot find upstream JoinAction: {0}", splitBuild);
            return false;
        }

        private AbstractBuild<?, ?> getSplitBuild(AbstractBuild<?, ?> build) {
            List causes = build.getCauses();
            AbstractBuild splitBuild = null;
            if (this.splitProject.getName().equals(build.getProject().getName())) {
                splitBuild = build;
            }
            for (Cause cause : causes) {
                Run upstreamRun;
                if (cause instanceof JoinAction.JoinCause || !(cause instanceof Cause.UpstreamCause)) continue;
                Cause.UpstreamCause uc = (Cause.UpstreamCause)cause;
                int upstreamBuildNum = uc.getUpstreamBuild();
                String upstreamProject = uc.getUpstreamProject();
                if (!this.splitProject.getName().equals(upstreamProject) || !((upstreamRun = this.splitProject.getBuildByNumber(upstreamBuildNum)) instanceof AbstractBuild)) continue;
                splitBuild = (AbstractBuild)upstreamRun;
                break;
            }
            return splitBuild;
        }

        protected boolean conditionIsMet(Result overallResult) {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            JoinDependency other = (JoinDependency)((Object)obj);
            if (!(this.splitProject == other.splitProject || this.splitProject != null && this.splitProject.equals(other.splitProject))) {
                return false;
            }
            return this.splitDependency == other.splitDependency || this.splitDependency != null && this.splitDependency.equals(other.splitDependency);
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + super.hashCode();
            hash = 79 * hash + (this.splitProject != null ? this.splitProject.hashCode() : 0);
            hash = 79 * hash + (this.splitDependency != null ? this.splitDependency.hashCode() : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Extension
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        public String getDisplayName() {
            return "Join Trigger";
        }

        public String getHelpFile() {
            return "/plugin/join/help/joinTrigger.html";
        }

        public JoinTrigger newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject joinTriggers;
            JSONObject experimentalpostbuild;
            JSONObject joinPublishers;
            LOGGER.finer(formData.toString());
            ArrayList<Publisher> newList = new ArrayList<Publisher>();
            JSONObject postbuild = formData.optJSONObject("postbuildactions");
            if (postbuild != null && (joinPublishers = postbuild.optJSONObject("joinPublishers")) != null) {
                this.extractAndAddPublisher(joinPublishers, this.getApplicableDescriptors(), newList, req);
            }
            if ((experimentalpostbuild = formData.optJSONObject("experimentalpostbuildactions")) != null && (joinTriggers = experimentalpostbuild.optJSONObject("joinPublishers")) != null) {
                LOGGER.finest("EPB: " + joinTriggers.toString() + joinTriggers.isArray());
                this.extractAndAddPublisher(joinTriggers, (List<Descriptor<Publisher>>)Publisher.all(), newList, req);
            }
            DescribableList publishers = new DescribableList(Saveable.NOOP, newList);
            LOGGER.finer("Parsed " + publishers.size() + " publishers");
            return new JoinTrigger((DescribableList<Publisher, Descriptor<Publisher>>)publishers, formData.getString("joinProjectsValue"), formData.has("evenIfDownstreamUnstable") && formData.getBoolean("evenIfDownstreamUnstable"));
        }

        private void extractAndAddPublisher(JSONObject json, List<Descriptor<Publisher>> applicableDescriptors, List<Publisher> newList, StaplerRequest req) throws Descriptor.FormException {
            for (Descriptor<Publisher> d : applicableDescriptors) {
                String name = d.getJsonSafeClassName();
                if (!json.has(name)) continue;
                Publisher instance = (Publisher)d.newInstance(req, json.getJSONObject(name));
                newList.add(instance);
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            boolean freeStyle = FreeStyleProject.class.isAssignableFrom(jobType);
            if (freeStyle) {
                return true;
            }
            Plugin mavenProjectPlugin = Hudson.getInstance().getPlugin("maven-plugin");
            return mavenProjectPlugin != null && AbstractMavenProject.class.isAssignableFrom(jobType);
        }

        public boolean showEvenIfUnstableOption(Class<? extends AbstractProject> jobType) {
            return !jobType.getName().contains("PromotionProcess");
        }

        public List<Descriptor<Publisher>> getApplicableDescriptors() {
            Plugin copyArchiver;
            ArrayList<Descriptor<Publisher>> list = new ArrayList<Descriptor<Publisher>>();
            Plugin parameterizedTrigger = Hudson.getInstance().getPlugin("parameterized-trigger");
            if (parameterizedTrigger != null) {
                list.add(Hudson.getInstance().getDescriptorByType(BuildTrigger.DescriptorImpl.class));
            }
            if ((copyArchiver = Hudson.getInstance().getPlugin("copyarchiver")) != null) {
                list.add((Descriptor<Publisher>)Hudson.getInstance().getDescriptorByType(CopyArchiverPublisher.CopyArchiverDescriptor.class));
            }
            return list;
        }

        public List<Descriptor<Publisher>> getApplicableExperimentalDescriptors(AbstractProject<?, ?> project) {
            List list = Functions.getPublisherDescriptors(project);
            LOGGER.finest("publisher count before removing publishers: " + list.size());
            list.remove(Hudson.getInstance().getDescriptorByType(DescriptorImpl.class));
            list.removeAll(this.getApplicableDescriptors());
            LOGGER.finest("publisher count after removing publishers: " + list.size());
            return list;
        }

        @Extension
        public static class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Hudson.getInstance().getProjects()) {
                    hudson.tasks.BuildTrigger t = (hudson.tasks.BuildTrigger)p.getPublishersList().get(hudson.tasks.BuildTrigger.class);
                    if (t == null || !t.onJobRenamed(oldName, newName)) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class RunListenerImpl
        extends RunListener<Run> {
            public RunListenerImpl() {
                super(Run.class);
            }

            public void onCompleted(Run run, TaskListener listener) {
                if (!(run instanceof AbstractBuild)) {
                    return;
                }
                AbstractBuild abstractBuild = (AbstractBuild)run;
                listener.getLogger().println("Notifying upstream projects of job completion");
                Object upstreamProject = null;
                boolean upstreamJobNumber = false;
                CauseAction ca = (CauseAction)run.getAction(CauseAction.class);
                if (ca == null) {
                    listener.getLogger().println("Join notifier requires a CauseAction");
                    return;
                }
                for (Cause c : ca.getCauses()) {
                    if (!(c instanceof Cause.UpstreamCause) || c instanceof JoinAction.JoinCause) continue;
                    Cause.UpstreamCause uc = (Cause.UpstreamCause)c;
                    this.notifyJob(abstractBuild, listener, uc.getUpstreamProject(), uc.getUpstreamBuild());
                }
            }

            private void notifyJob(AbstractBuild<?, ?> abstractBuild, TaskListener listener, String upstreamProjectName, int upstreamJobNumber) {
                List upstreamList = Items.fromNameList((String)upstreamProjectName, AbstractProject.class);
                if (upstreamList.size() != 1) {
                    listener.getLogger().println("Join notifier cannot find upstream project: " + upstreamProjectName);
                    return;
                }
                AbstractProject upstreamProject = (AbstractProject)upstreamList.get(0);
                Run upstreamRun = upstreamProject.getBuildByNumber(upstreamJobNumber);
                if (upstreamRun == null) {
                    listener.getLogger().println("Join notifier cannot find upstream run: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                if (!(upstreamRun instanceof AbstractBuild)) {
                    LOGGER.fine("Upstream run is not an AbstractBuild: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                AbstractBuild upstreamBuild = (AbstractBuild)upstreamRun;
                JoinAction ja = (JoinAction)upstreamRun.getAction(JoinAction.class);
                if (ja == null) {
                    LOGGER.finer("Join notifier cannot find upstream JoinAction: " + upstreamProjectName + " number " + upstreamJobNumber);
                    return;
                }
                listener.getLogger().println("Notifying upstream of completion: " + upstreamProjectName + " #" + upstreamJobNumber);
                ja.downstreamFinished(upstreamBuild, abstractBuild, listener);
            }
        }
    }
}

