/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jsunit;

import hudson.plugins.jsunit.TestReportTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JSUnitReportTransformer
implements TestReportTransformer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_FILE_POSTFIX = ".xml";
    public static final String JUNIT_FILE_PREFIX = "TEST-";
    private static final String TEMP_JUNIT_FILE_STR = "temp-junit.xml";
    public static final String JSUNIT_TO_JUNIT_XSLFILE_STR = "jsunit-to-junit.xsl";
    private transient boolean xslIsInitialized;
    private transient Transformer jsUnitTransformer;
    private transient Transformer writerTransformer;
    private transient DocumentBuilder xmlDocumentBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(InputStream jsUnitFileStream, File junitOutputPath) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        this.initialize();
        File junitTargetFile = new File(junitOutputPath, TEMP_JUNIT_FILE_STR);
        FileOutputStream fileOutputStream = new FileOutputStream(junitTargetFile);
        try {
            this.jsUnitTransformer.transform(new StreamSource(jsUnitFileStream), new StreamResult(fileOutputStream));
        }
        finally {
            fileOutputStream.close();
        }
        this.splitJUnitFile(junitTargetFile, junitOutputPath);
        junitTargetFile.delete();
    }

    private void initialize() throws TransformerFactoryConfigurationError, TransformerConfigurationException, ParserConfigurationException {
        if (!this.xslIsInitialized) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.jsUnitTransformer = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream(JSUNIT_TO_JUNIT_XSLFILE_STR)));
            this.writerTransformer = transformerFactory.newTransformer();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.xmlDocumentBuilder = factory.newDocumentBuilder();
            this.xslIsInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitJUnitFile(File junitFile, File junitOutputPath) throws SAXException, IOException, TransformerException {
        Document document = this.xmlDocumentBuilder.parse(junitFile);
        NodeList elementsByTagName = ((Element)document.getElementsByTagName("testsuites").item(0)).getElementsByTagName("testsuite");
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element element = (Element)elementsByTagName.item(i);
            DOMSource source = new DOMSource(element);
            File junitOutputFile = new File(junitOutputPath, JUNIT_FILE_PREFIX + element.getAttribute("name") + JUNIT_FILE_POSTFIX);
            FileOutputStream fileOutputStream = new FileOutputStream(junitOutputFile);
            try {
                StreamResult result = new StreamResult(fileOutputStream);
                this.writerTransformer.transform(source, result);
                continue;
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

