/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jsunit;

import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.plugins.jsunit.TestReportTransformer;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSUnitArchiver
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JUNIT_REPORTS_PATH = "temporary-junit-reports";
    private final BuildListener listener;
    private final String testResultsPattern;
    private TestReportTransformer unitReportTransformer;

    public JSUnitArchiver(BuildListener listener, String testResults, TestReportTransformer unitReportTransformer) throws TransformerException {
        this.listener = listener;
        this.testResultsPattern = testResults;
        this.unitReportTransformer = unitReportTransformer;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        Boolean retValue = Boolean.TRUE;
        String[] jsUnitFiles = this.findJSUnitReports(ws);
        if (jsUnitFiles.length > 0) {
            File junitOutputPath = new File(ws, JUNIT_REPORTS_PATH);
            junitOutputPath.mkdirs();
            for (String jsUnitFileName : jsUnitFiles) {
                FileInputStream fileStream = new FileInputStream(new File(ws, jsUnitFileName));
                try {
                    this.unitReportTransformer.transform(fileStream, junitOutputPath);
                }
                catch (TransformerException te) {
                    throw new IOException2("Could not transform the JSUnit report. Please report this issue to the plugin author", (Throwable)te);
                }
                catch (SAXException se) {
                    throw new IOException2("Could not transform the JSUnit report. Please report this issue to the plugin author", (Throwable)se);
                }
                catch (ParserConfigurationException pce) {
                    throw new IOException2("Could not initalize the XML parser. Please report this issue to the plugin author", (Throwable)pce);
                }
                finally {
                    fileStream.close();
                }
            }
        } else {
            retValue = Boolean.FALSE;
        }
        return retValue;
    }

    private String[] findJSUnitReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.testResultsPattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] jsUnitFiles = ds.getIncludedFiles();
        if (jsUnitFiles.length == 0) {
            this.listener.fatalError("No JSUnit test report files were found. Configuration error?");
        }
        return jsUnitFiles;
    }
}

