/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jswidgets;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Node;
import hudson.plugins.jswidgets.JsBaseAction;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsBuildAction
extends JsBaseAction {
    private static final Logger LOG = Logger.getLogger(JsBuildAction.class.getName());
    private final AbstractBuild<?, ?> build;
    private static final HashMap<EditType, String> EDIT_TYPE_SYMBOLS = new HashMap();

    public JsBuildAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    @Override
    public String getUrlName() {
        return "jswidgets";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public AbstractProject<?, ?> getProject() {
        return this.build.getProject();
    }

    public String getBuiltOn() {
        Node builtOnNode = this.build.getBuiltOn();
        if (builtOnNode == null) {
            return "UNKNOWN";
        }
        return builtOnNode.getNodeDescription();
    }

    public Collection<String> getChangeSetEntries(ChangeLogSet.Entry entry) {
        Collection affectedFiles;
        try {
            affectedFiles = entry.getAffectedFiles();
        }
        catch (UnsupportedOperationException e) {
            LOG.warning("Got " + e + ", falling back to getAffectedPaths");
            return entry.getAffectedPaths();
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (ChangeLogSet.AffectedFile affectedFile : affectedFiles) {
            entries.add(EDIT_TYPE_SYMBOLS.get(affectedFile.getEditType()) + affectedFile.getPath());
        }
        return entries;
    }

    static {
        EDIT_TYPE_SYMBOLS.put(EditType.ADD, "+");
        EDIT_TYPE_SYMBOLS.put(EditType.DELETE, "-");
        EDIT_TYPE_SYMBOLS.put(EditType.EDIT, "#");
    }
}

