/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jswidgets;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.jswidgets.JsBaseAction;
import hudson.plugins.jswidgets.JsBuildAction;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsJobAction
extends JsBaseAction {
    private static final Logger LOG = Logger.getLogger(JsJobAction.class.getName());
    private final transient AbstractProject<?, ?> project;

    public JsJobAction(AbstractProject<?, ?> project) {
        this.project = project;
        List builds = project.getBuilds();
        for (Object object : builds) {
            AbstractBuild build = (AbstractBuild)object;
            List jsBuildActions = build.getActions(JsBuildAction.class);
            if (jsBuildActions.size() == 0) {
                JsBuildAction jsBuildAction = new JsBuildAction(build);
                build.addAction((Action)jsBuildAction);
                LOG.fine("Adding " + jsBuildAction + " to " + build);
            } else {
                LOG.fine(build + " already has " + jsBuildActions);
            }
            LOG.fine(build + ":" + build.getActions());
        }
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getJobDescription(boolean escapeApostroph) {
        String description = this.project.getDescription().replace("\n", "").replace("\r", "");
        return escapeApostroph ? description.replace("'", "\\'") : description;
    }
}

