/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jswidgets;

import hudson.Functions;
import hudson.model.Action;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

public abstract class JsBaseAction
implements Action {
    private static final Logger LOG = Logger.getLogger(JsBaseAction.class.getName());

    public boolean wantHtml(StaplerRequest request) {
        boolean wantHtml = Boolean.parseBoolean(request.getParameter("html"));
        LOG.finest("wantHtml=" + wantHtml);
        return wantHtml;
    }

    public boolean skipDescription(StaplerRequest request) {
        boolean skipDescription = Boolean.parseBoolean(request.getParameter("skipDescription"));
        LOG.finest("skipDescription=" + skipDescription);
        return skipDescription;
    }

    public String getBaseUrl(StaplerRequest req) {
        String requestURL = String.valueOf(req.getRequestURL());
        String requestURI = req.getRequestURI();
        String baseUrl = requestURL.substring(0, requestURL.length() - requestURI.length()) + req.getContextPath();
        LOG.finest("baseUrl=" + baseUrl + " from requestURL=" + requestURL);
        return baseUrl;
    }

    public String getImagesUrl(StaplerRequest req) {
        String imagesPath = this.getBaseUrl(req) + Functions.getResourcePath() + "/images/16x16";
        LOG.finest("imagesPath=" + imagesPath);
        return imagesPath;
    }

    public final String getDisplayName() {
        return "JS Widgets";
    }

    public final String getIconFileName() {
        return "/plugin/jswidgets/img/jsindex.png";
    }

    public String getUrlName() {
        return "jswidgets";
    }
}

