/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.junitattachments.AttachmentPublisher;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AttachmentPublisher
extends TestDataPublisher {
    @DataBoundConstructor
    public AttachmentPublisher() {
    }

    public static FilePath getAttachmentPath(AbstractBuild<?, ?> build) {
        return new FilePath(new File(build.getRootDir().getAbsolutePath())).child("junit-attachments");
    }

    public Data getTestData(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestResult testResult) throws IOException, InterruptedException {
        HashMap<String, String> reports = new HashMap<String, String>();
        for (SuiteResult suiteResult : testResult.getSuites()) {
            String f = suiteResult.getFile();
            if (f == null) continue;
            for (String className : suiteResult.getClassNames()) {
                reports.put(className, f);
            }
        }
        FilePath attachmentsStorage = AttachmentPublisher.getAttachmentPath(build);
        HashMap<String, List<String>> attachments = new HashMap<String, List<String>>();
        for (Map.Entry report : reports.entrySet()) {
            String className;
            className = (String)report.getKey();
            FilePath testDir = build.getWorkspace().child((String)report.getValue()).getParent().child(className);
            FilePath target = attachmentsStorage.child(className);
            if (!testDir.exists()) continue;
            target.mkdirs();
            if (testDir.copyRecursiveTo(target) <= 0) continue;
            DirectoryScanner d = new DirectoryScanner();
            d.setBasedir(target.getRemote());
            d.scan();
            attachments.put(className, Arrays.asList(d.getIncludedFiles()));
        }
        if (attachments.isEmpty()) {
            return null;
        }
        return new Data(attachments);
    }
}

