/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import hudson.FilePath;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentTestAction
extends TestAction {
    private final FilePath storage;
    private final List<String> attachments;
    private final TestObject testObject;

    public AttachmentTestAction(TestObject testObject, FilePath storage, List<String> attachments) {
        this.storage = storage;
        this.testObject = testObject;
        this.attachments = attachments;
    }

    public String getDisplayName() {
        return "Attachments";
    }

    public String getIconFileName() {
        return "package.gif";
    }

    public String getUrlName() {
        return "attachments";
    }

    public DirectoryBrowserSupport doDynamic() {
        return new DirectoryBrowserSupport((ModelObject)this, this.storage, "Attachments", "package.gif", true);
    }

    public String annotate(String text) {
        String url = Hudson.getInstance().getRootUrl() + this.testObject.getOwner().getUrl() + "testReport" + this.testObject.getUrl() + "/attachments/";
        for (String attachment : this.attachments) {
            text = text.replace(attachment, "<a href=\"" + url + attachment + "\">" + attachment + "</a>");
        }
        return text;
    }

    public List<String> getAttachments() {
        return this.attachments;
    }

    public TestObject getTestObject() {
        return this.testObject;
    }
}

