/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.junitattachments;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.junitattachments.AttachmentPublisher;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTestDataMethodObject {
    private static final Logger LOG = Logger.getLogger(GetTestDataMethodObject.class.getName());
    private final AbstractBuild<?, ?> build;
    private final TestResult testResult;
    private final Map<String, List<String>> attachments;
    private final Map<String, String> reports;

    public GetTestDataMethodObject(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestResult testResult) {
        this.build = build;
        this.testResult = testResult;
        this.attachments = new HashMap<String, List<String>>();
        this.reports = new HashMap<String, String>();
    }

    public Map<String, List<String>> getAttachments() throws IllegalStateException, IOException, InterruptedException {
        FilePath attachmentsStorage = AttachmentPublisher.getAttachmentPath(this.build);
        this.getReports();
        LOG.fine("reports: " + this.reports);
        for (Map.Entry<String, String> report : this.reports.entrySet()) {
            String className = report.getKey();
            FilePath target = attachmentsStorage.child(className);
            this.attachFilesForReport(report, className, target);
            this.attachStdInAndOut(report, className, target);
        }
        return this.attachments;
    }

    private void attachFilesForReport(Map.Entry<String, String> report, String className, FilePath target) throws IOException, InterruptedException {
        FilePath testDir = this.build.getWorkspace().child(report.getValue()).getParent().child(className);
        if (testDir.exists()) {
            target.mkdirs();
            if (testDir.copyRecursiveTo(target) > 0) {
                DirectoryScanner d = new DirectoryScanner();
                d.setBasedir(target.getRemote());
                d.scan();
                this.attachments.put(className, Arrays.asList(d.getIncludedFiles()));
            }
        }
    }

    private void getReports() {
        for (SuiteResult suiteResult : this.testResult.getSuites()) {
            String f = suiteResult.getFile();
            if (f == null) continue;
            for (String className : suiteResult.getClassNames()) {
                this.reports.put(className, f);
            }
        }
    }

    private void attachStdInAndOut(Map.Entry<String, String> report, String className, FilePath target) throws IOException, InterruptedException {
        FilePath stdInAndOut = this.build.getWorkspace().child(report.getValue()).getParent().child(className + "-output.txt");
        LOG.fine("stdInAndOut: " + stdInAndOut.absolutize());
        if (stdInAndOut.exists()) {
            target.mkdirs();
            FilePath stdInAndOutTarget = new FilePath(target, stdInAndOut.getName());
            stdInAndOut.copyTo(stdInAndOutTarget);
            if (this.attachments.containsKey(className)) {
                ArrayList<String> list = new ArrayList<String>((Collection)this.attachments.get(className));
                list.add(stdInAndOutTarget.getName());
                this.attachments.put(className, list);
            } else {
                this.attachments.put(className, Arrays.asList(stdInAndOutTarget.getName()));
            }
        }
    }
}

