/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jython
extends Builder {
    private final String command;

    private Jython(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PySystemState sys = new PySystemState();
        sys.setCurrentWorkingDir(build.getWorkspace().getRemote());
        PythonInterpreter interp = new PythonInterpreter(null, sys);
        interp.setOut((OutputStream)listener.getLogger());
        interp.setErr((OutputStream)listener.getLogger());
        interp.exec(this.getCommand());
        interp.cleanup();
        build.setResult(Result.SUCCESS);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public DescriptorImpl() {
            super(Jython.class);
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) {
            return new Jython(formData.getString("jython"));
        }

        public String getDisplayName() {
            return "Execute Jython script";
        }

        public String getHelpFile() {
            return "/plugin/jython/help.html";
        }
    }
}

