/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.kagemai.KagemaiProjectProperty;
import hudson.plugins.kagemai.Messages;
import hudson.plugins.kagemai.model.KagemaiIssue;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagemaiBuildAction
implements Action {
    private AbstractBuild<?, ?> owner;
    private List<KagemaiIssue> issues;
    private String siteName;
    private String projectId;

    public KagemaiBuildAction(AbstractBuild<?, ?> owner, List<KagemaiIssue> issues, String siteName, String projectId) {
        this.owner = owner;
        this.issues = issues;
        this.siteName = siteName;
        this.projectId = projectId;
    }

    public String getIssuesList() {
        KagemaiProjectProperty kagemaiProjectProperty = (KagemaiProjectProperty)((AbstractProject)this.owner.getParent()).getProperty(KagemaiProjectProperty.class);
        if (kagemaiProjectProperty == null || kagemaiProjectProperty.getSite() == null) {
            return "";
        }
        String baseUrl = kagemaiProjectProperty.getSite().getBaseUrl().toExternalForm();
        String projectId = kagemaiProjectProperty.getProjectId();
        StringBuilder sb = new StringBuilder();
        for (KagemaiIssue issue : this.issues) {
            sb.append(String.format("<li>" + "<a href='%s?project=%s&action=view_report&id=%s'>" + issue.getId() + "</a>" + " - " + issue.getSummary() + "</li>" + "\n", baseUrl, projectId, issue.getId()));
        }
        return sb.toString();
    }

    public List<KagemaiIssue> getIssues() {
        return this.issues;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDisplayName() {
        return Messages.action_dispname();
    }

    public String getIconFileName() {
        return "/plugin/kagemai/images/kagemai.gif";
    }

    public String getUrlName() {
        return "kagemaiResult";
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }
}

