/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.kagemai.KagemaiBuildAction;
import hudson.plugins.kagemai.KagemaiProjectProperty;
import hudson.plugins.kagemai.model.KagemaiIssue;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class KagemaiChangelogAnnotator
extends ChangeLogAnnotator {
    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        KagemaiProjectProperty kagemaiProjectProperty = (KagemaiProjectProperty)((AbstractProject)build.getParent()).getProperty(KagemaiProjectProperty.class);
        if (kagemaiProjectProperty == null) {
            return;
        }
        if (kagemaiProjectProperty.getSite() == null) {
            return;
        }
        if (!kagemaiProjectProperty.isLinkEnabled()) {
            return;
        }
        String regex = kagemaiProjectProperty.getRegex();
        Pattern pattern = Pattern.compile(regex);
        HashSet<Integer> bugIds = new HashSet<Integer>();
        for (MarkupText.SubText token : text.findTokens(pattern)) {
            try {
                bugIds.add(KagemaiChangelogAnnotator.getId((MarkupText.SubText)token));
            }
            catch (NumberFormatException e) {}
        }
        if (bugIds.size() == 0) {
            return;
        }
        KagemaiBuildAction action = (KagemaiBuildAction)build.getAction(KagemaiBuildAction.class);
        if (action == null) {
            action = new KagemaiBuildAction(build, kagemaiProjectProperty.getKagemaiSession().getIssuesMap(bugIds), kagemaiProjectProperty.getSite().getBaseUrl().toExternalForm(), kagemaiProjectProperty.getProjectId());
        }
        List issues = action.getIssues();
        for (MarkupText.SubText token : text.findTokens(pattern)) {
            Integer key = null;
            try {
                key = KagemaiChangelogAnnotator.getId((MarkupText.SubText)token);
            }
            catch (Exception e) {
                continue;
            }
            String summary = null;
            for (KagemaiIssue issue : issues) {
                if (key.intValue() != issue.getId()) continue;
                summary = issue.getSummary();
            }
            if (StringUtils.isEmpty(summary)) {
                token.surroundWith(String.format("<a href='%s?project=%s&action=view_report&id=%s'>", action.getSiteName(), action.getProjectId(), key), "</a>");
                continue;
            }
            token.surroundWith(String.format("<a href='%s?project=%s&action=view_report&id=%s' tooltip='%s'>", action.getSiteName(), action.getProjectId(), key, summary), "</a>");
        }
    }

    private static int getId(MarkupText.SubText token) {
        String id = null;
        int i = 0;
        while (true) {
            id = token.group(i);
            try {
                return Integer.valueOf(id);
            }
            catch (NumberFormatException e) {
                ++i;
                continue;
            }
            break;
        }
    }
}

