/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.Util;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.kagemai.KagemaiProjectProperty;
import hudson.plugins.kagemai.KagemaiSession;
import hudson.plugins.kagemai.KagemaiSite;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagemaiProjectProperty
extends JobProperty<Job<?, ?>> {
    private String siteName;
    private String projectId;
    private String regex;
    private boolean linkEnabled;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public KagemaiProjectProperty(String siteName, String projectId, String regex, boolean linkEnabled) {
        KagemaiSite[] sites;
        String name = siteName;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getName();
        }
        this.siteName = Util.fixEmptyAndTrim((String)name);
        this.projectId = Util.fixEmptyAndTrim((String)projectId);
        this.regex = Util.fixEmptyAndTrim((String)regex);
        this.linkEnabled = linkEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRegex() {
        if (StringUtils.isEmpty((String)this.regex)) {
            this.regex = "\\b[0-9.]*[0-9]\\b";
        }
        return this.regex;
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }

    public KagemaiSession getKagemaiSession() {
        return new KagemaiSession(this.getSite().getBaseUrl(), this.projectId, this.getSite().getBasicUserName(), this.getSite().getBasicPassword(), this.getSite().getEncode());
    }

    public KagemaiSite getSite() {
        KagemaiSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (KagemaiSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ String access$000(KagemaiProjectProperty x0) {
        return x0.siteName;
    }
}

