/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.plugins.kagemai.model.KagemaiIssue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class KagemaiSession {
    public static final String LINK_FORMAT = "<a href='%s?project=%s&action=view_report&id=%s'>";
    public static final String LINK_FORMAT_WITH_TOOLTIP = "<a href='%s?project=%s&action=view_report&id=%s' tooltip='%s'>";
    private static final String TITLE_REGEX = "/<h1>.+?:(.*)</h1>/";
    private URL baseUrl;
    private String basicUserName;
    private String basicPassword;
    private String projectId;
    private String encode;
    private HttpClient client;
    private static final Logger LOGGER = Logger.getLogger(KagemaiSession.class.getName());

    public KagemaiSession(URL baseUrl, String basicUserName, String basicPassword) {
        this.baseUrl = baseUrl;
        this.basicUserName = basicUserName;
        this.basicPassword = basicPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnect() {
        boolean result = false;
        this.client = new HttpClient();
        PostMethod method = new PostMethod(this.baseUrl.toExternalForm());
        if (this.isAuthentication()) {
            this.setAuthentication();
            method.setDoAuthentication(true);
        }
        try {
            if (this.client.executeMethod((HttpMethod)method) == 200) {
                result = true;
            }
        }
        catch (HttpException e) {
            LOGGER.log(Level.WARNING, "can not connect kagemai site", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "error in kagemai response processing", e);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    public KagemaiSession(URL baseUrl, String projectId, String basicUserName, String basicUserPassword, String encode) {
        this.baseUrl = baseUrl;
        this.basicUserName = basicUserName;
        this.basicPassword = basicUserPassword;
        this.projectId = projectId;
        this.encode = encode;
        this.initClient();
    }

    private void initClient() {
        this.client = new HttpClient();
        if (this.isAuthentication()) {
            this.setAuthentication();
        }
    }

    private void setAuthentication() {
        int port = this.baseUrl.getPort() == -1 ? this.baseUrl.getDefaultPort() : this.baseUrl.getPort();
        this.client.getState().setCredentials(new AuthScope(this.baseUrl.getHost(), port), (Credentials)new UsernamePasswordCredentials(this.basicUserName, this.basicPassword));
    }

    private PostMethod createMethod() {
        PostMethod method = new PostMethod(this.baseUrl.toExternalForm());
        if (this.isAuthentication()) {
            method.setDoAuthentication(true);
        }
        method.setParameter("project", this.projectId);
        method.setParameter("action", "view_report");
        method.setParameter("jp_enc_test", "\u65e5");
        return method;
    }

    private boolean isAuthentication() {
        return !StringUtils.isEmpty((String)this.basicUserName) && !StringUtils.isEmpty((String)this.basicPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KagemaiIssue> getIssuesMap(HashSet<Integer> bugIds) {
        if (bugIds.size() == 0) {
            return null;
        }
        ArrayList<KagemaiIssue> result = new ArrayList<KagemaiIssue>();
        for (Integer i : bugIds) {
            PostMethod method = null;
            try {
                String line;
                method = this.createMethod();
                method.setParameter("id", String.valueOf(i));
                this.client.getParams().setContentCharset(this.encode);
                if (this.client.executeMethod((HttpMethod)method) != 200) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), this.encode));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                String summary = KagemaiSession.getSummary((String)sb.toString());
                if (StringUtils.isEmpty((String)summary)) continue;
                result.add(new KagemaiIssue(i.intValue(), summary));
            }
            catch (HttpException e) {
                LOGGER.log(Level.WARNING, "can not connect kagemai site", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "error in kagemai response processing", e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return result;
    }

    private static String getSummary(String body) {
        String result = null;
        Perl5Util util = new Perl5Util();
        if (util.match("/<h1>.+?:(.*)</h1>/", body)) {
            result = util.group(1);
        }
        return result;
    }
}

