/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.kagemai.KagemaiSession;
import hudson.plugins.kagemai.KagemaiSite;
import hudson.plugins.kagemai.Messages;
import hudson.util.CopyOnWriteList;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagemaiProjectProperty
extends JobProperty<Job<?, ?>> {
    private String siteName;
    private String projectId;
    private String regex;
    private boolean linkEnabled;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public KagemaiProjectProperty(String siteName, String projectId, String regex, boolean linkEnabled) {
        KagemaiSite[] sites;
        String name = siteName;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getName();
        }
        this.siteName = Util.fixEmptyAndTrim((String)name);
        this.projectId = Util.fixEmptyAndTrim((String)projectId);
        this.regex = Util.fixEmptyAndTrim((String)regex);
        this.linkEnabled = linkEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRegex() {
        if (StringUtils.isEmpty((String)this.regex)) {
            this.regex = "\\b[0-9.]*[0-9]\\b";
        }
        return this.regex;
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }

    public KagemaiSession getKagemaiSession() {
        return new KagemaiSession(this.getSite().getBaseUrl(), this.projectId, this.getSite().getBasicUserName(), this.getSite().getBasicPassword(), this.getSite().getEncode());
    }

    public KagemaiSite getSite() {
        KagemaiSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (KagemaiSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<KagemaiSite> sites = new CopyOnWriteList();

        DescriptorImpl() {
            super(KagemaiProjectProperty.class);
            this.load();
        }

        public String getDisplayName() {
            return "Kagemai";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            KagemaiProjectProperty kagemaiProjectProperty = (KagemaiProjectProperty)((Object)req.bindParameters(KagemaiProjectProperty.class, "kagemai."));
            if (kagemaiProjectProperty.siteName == null) {
                kagemaiProjectProperty = null;
            }
            return kagemaiProjectProperty;
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.sites.replaceBy((Collection)req.bindParametersToList(KagemaiSite.class, "kagemai."));
            this.save();
            return true;
        }

        public KagemaiSite[] getSites() {
            return (KagemaiSite[])this.sites.toArray((Object[])new KagemaiSite[0]);
        }

        public void doRegexCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String regex = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (regex == null) {
                        this.ok();
                        return;
                    }
                    try {
                        Pattern.compile(regex);
                        this.ok();
                        return;
                    }
                    catch (PatternSyntaxException e) {
                        this.error(Messages.error_regex());
                        return;
                    }
                }
            }.process();
        }

        public void doLoginCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String baseUrl = Util.fixEmpty((String)this.request.getParameter("baseUrl"));
                    String basicUserName = Util.fixEmpty((String)this.request.getParameter("basicUserName"));
                    String basicPassword = Util.fixEmpty((String)this.request.getParameter("basicPassword"));
                    if (StringUtils.isEmpty((String)baseUrl)) {
                        this.ok();
                        return;
                    }
                    KagemaiSession session = new KagemaiSession(new URL(baseUrl), basicUserName, basicPassword);
                    if (session.isConnect()) {
                        this.ok();
                        return;
                    }
                    this.error(Messages.error_login());
                }
            }.process();
        }
    }
}

