/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.kagemai.KagemaiSession;
import hudson.plugins.kagemai.KagemaiSite;
import hudson.plugins.kagemai.Messages;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagemaiProjectProperty
extends JobProperty<Job<?, ?>> {
    private String siteName;
    private String projectId;
    private String regex;
    private boolean linkEnabled;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public KagemaiProjectProperty(String siteName, String projectId, String regex, boolean linkEnabled) {
        KagemaiSite[] sites;
        String name = siteName;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getName();
        }
        this.siteName = Util.fixEmptyAndTrim((String)name);
        this.projectId = Util.fixEmptyAndTrim((String)projectId);
        this.regex = Util.fixEmptyAndTrim((String)regex);
        this.linkEnabled = linkEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRegex() {
        if (StringUtils.isEmpty((String)this.regex)) {
            this.regex = "\\b[0-9.]*[0-9]\\b";
        }
        return this.regex;
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }

    public KagemaiSession getKagemaiSession() {
        return new KagemaiSession(this.getSite().getBaseUrl(), this.projectId, this.getSite().getBasicUserName(), this.getSite().getBasicPassword(), this.getSite().getEncode());
    }

    public KagemaiSite getSite() {
        KagemaiSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (KagemaiSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<KagemaiSite> sites = new CopyOnWriteList();

        DescriptorImpl() {
            super(KagemaiProjectProperty.class);
            this.load();
        }

        public String getDisplayName() {
            return "Kagemai";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            KagemaiProjectProperty kagemaiProjectProperty = (KagemaiProjectProperty)((Object)req.bindParameters(KagemaiProjectProperty.class, "kagemai."));
            if (kagemaiProjectProperty.siteName == null) {
                kagemaiProjectProperty = null;
            }
            return kagemaiProjectProperty;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.sites.replaceBy((Collection)req.bindParametersToList(KagemaiSite.class, "kagemai."));
            this.save();
            return true;
        }

        public KagemaiSite[] getSites() {
            return (KagemaiSite[])this.sites.toArray((Object[])new KagemaiSite[0]);
        }

        public FormValidation doRegexCheck(@QueryParameter String value) {
            String regex = Util.fixEmpty((String)value);
            if (regex == null) {
                return FormValidation.ok();
            }
            try {
                Pattern.compile(regex);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)Messages.error_regex());
            }
        }

        public FormValidation doLoginCheck(@QueryParameter String baseUrl, @QueryParameter String basicUserName, @QueryParameter String basicPassword) throws IOException {
            baseUrl = Util.fixEmpty((String)baseUrl);
            basicUserName = Util.fixEmpty((String)basicUserName);
            basicPassword = Util.fixEmpty((String)basicPassword);
            if (StringUtils.isEmpty((String)baseUrl)) {
                return FormValidation.ok();
            }
            KagemaiSession session = new KagemaiSession(new URL(baseUrl), basicUserName, basicPassword);
            if (session.isConnect()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.error_login());
        }
    }
}

