/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.kagemai.KagemaiBuildAction;
import hudson.plugins.kagemai.KagemaiProjectProperty;
import hudson.plugins.kagemai.KagemaiSession;
import hudson.plugins.kagemai.KagemaiSite;
import hudson.plugins.kagemai.Messages;
import hudson.plugins.kagemai.model.KagemaiIssue;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagemaiPublisher
extends Recorder {
    KagemaiPublisher() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        KagemaiSite site = KagemaiSite.get(build.getProject());
        if (site == null) {
            build.setResult(Result.FAILURE);
            return true;
        }
        HashSet<Integer> bugIds = new HashSet<Integer>();
        KagemaiProjectProperty mpp = (KagemaiProjectProperty)((AbstractProject)build.getParent()).getProperty(KagemaiProjectProperty.class);
        if (mpp != null && mpp.getSite() != null) {
            String regex = mpp.getRegex();
            Pattern pattern = Pattern.compile(regex);
            for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                Matcher matcher = pattern.matcher(entry.getMsg());
                while (matcher.find()) {
                    try {
                        bugIds.add(Integer.valueOf(matcher.group(matcher.groupCount())));
                    }
                    catch (NumberFormatException e) {}
                }
            }
        } else {
            build.setResult(Result.FAILURE);
            return true;
        }
        KagemaiSession kagemaiSession = mpp.getKagemaiSession();
        List<KagemaiIssue> issues = null;
        if (!bugIds.isEmpty() && kagemaiSession != null) {
            issues = kagemaiSession.getIssuesMap(bugIds);
        }
        if (issues != null && issues.size() > 0) {
            Collections.sort(issues);
        }
        KagemaiBuildAction action = new KagemaiBuildAction(build, issues, mpp.getSiteName(), mpp.getProjectId());
        build.addAction((Action)action);
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(KagemaiPublisher.class);
        }

        public String getDisplayName() {
            return Messages.publisher_dispname();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public KagemaiPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new KagemaiPublisher();
        }
    }
}

