/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kagemai;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.kagemai.KagemaiProjectProperty;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KagemaiSite {
    private static final String DEFAULT_ENCODE = "EUC_JP";
    private URL baseUrl;
    private String basicUserName;
    private String basicPassword;
    private String encode;

    @DataBoundConstructor
    public KagemaiSite(String regex, URL baseUrl, String basicUserName, String basicPassword, String encode) {
        this.baseUrl = baseUrl;
        this.basicUserName = Util.fixEmptyAndTrim((String)basicUserName);
        this.basicPassword = Util.fixEmptyAndTrim((String)basicPassword);
        this.encode = encode;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getBasicUserName() {
        return this.basicUserName;
    }

    public String getBasicPassword() {
        return this.basicPassword;
    }

    public String getName() {
        return this.baseUrl.toExternalForm();
    }

    public String getEncode() {
        return StringUtils.isEmpty((String)this.encode) ? DEFAULT_ENCODE : this.encode;
    }

    public static KagemaiSite get(AbstractProject<?, ?> project) {
        KagemaiSite site;
        KagemaiProjectProperty mpp = (KagemaiProjectProperty)project.getProperty(KagemaiProjectProperty.class);
        if (mpp != null && (site = mpp.getSite()) != null) {
            return site;
        }
        KagemaiSite[] sites = KagemaiProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }
}

