/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kundo;

import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.kundo.Kundo;
import hudson.plugins.kundo.KundoInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kundo
extends Builder {
    private final String phases;
    private final String properties;
    private final String kundoName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    @DataBoundConstructor
    public Kundo(String phases, String properties, String kundoName) {
        this.phases = phases;
        this.properties = properties;
        this.kundoName = kundoName;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getPhases() {
        return this.phases;
    }

    public KundoInstallation getKundo() {
        for (KundoInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.kundoName == null || !i.getName().equals(this.kundoName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execType = launcher.isUnix() ? "kundo" : "kundo.bat";
        String normalizedPhases = this.phases.replaceAll("[\t\r\n]+", " ");
        String normalizedProperties = this.properties.replaceAll("[\t\r\n]+", " ");
        String[] splitProperties = normalizedProperties.split(" ");
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (String property : splitProperties) {
            String[] splitProp;
            if (property.indexOf("=") == -1 || (splitProp = property.split("=")).length != 2) continue;
            propMap.put(splitProp[0], splitProp[1]);
        }
        KundoInstallation currentInstall = this.getKundo();
        if (currentInstall == null) {
            args.add(execType);
        } else {
            File exec = currentInstall.getExecutable();
            if (!currentInstall.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        if (!propMap.isEmpty()) {
            args.addKeyValuePairs("-D", propMap);
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedPhases);
        Map env = build.getEnvVars();
        if (currentInstall != null) {
            env.put("KUNDO_HOME", currentInstall.getKundoHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), env, (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

