/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.kundo;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.kundo.KundoInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kundo
extends Builder {
    private final String phases;
    private final String properties;
    private final String kundoName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public Kundo(String phases, String properties, String kundoName) {
        this.phases = phases;
        this.properties = properties;
        this.kundoName = kundoName;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getPhases() {
        return this.phases;
    }

    public KundoInstallation getKundo() {
        for (KundoInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.kundoName == null || !i.getName().equals(this.kundoName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execType = launcher.isUnix() ? "kundo" : "kundo.bat";
        String normalizedPhases = this.phases.replaceAll("[\t\r\n]+", " ");
        String normalizedProperties = this.properties.replaceAll("[\t\r\n]+", " ");
        String[] splitProperties = normalizedProperties.split(" ");
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (String property : splitProperties) {
            String[] splitProp;
            if (property.indexOf("=") == -1 || (splitProp = property.split("=")).length != 2) continue;
            propMap.put(splitProp[0], splitProp[1]);
        }
        KundoInstallation currentInstall = this.getKundo();
        if (currentInstall == null) {
            args.add(execType);
        } else {
            File exec = currentInstall.getExecutable();
            if (!currentInstall.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        if (!propMap.isEmpty()) {
            args.addKeyValuePairs("-D", propMap);
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedPhases);
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (currentInstall != null) {
            env.put("KUNDO_HOME", currentInstall.getKundoHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        private volatile KundoInstallation[] installations = new KundoInstallation[0];

        private DescriptorImpl() {
            super(Kundo.class);
            this.load();
        }

        public String getHelpFile() {
            return "/plugin/kundo/help.html";
        }

        public String getDisplayName() {
            return "Invoke Kundo job";
        }

        public KundoInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.installations = req.bindParametersToList(KundoInstallation.class, "kundo.").toArray(new KundoInstallation[0]);
            this.save();
            return true;
        }

        public FormValidation doCheckKundoHome(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            File f = new File(Util.fixNull((String)value));
            if (!f.isDirectory()) {
                return FormValidation.error((String)(f + " is not a directory"));
            }
            if (!(new File(f, "bin").exists() || new File(f, "lib").exists() || new File(f, "conf").exists() || new File(f, "groovy").exists())) {
                return FormValidation.error((String)(f + " isn't a proper Kundo kernel"));
            }
            if (!new File(f, "bin/kundo").exists()) {
                return FormValidation.error((String)(f + " isn't a proper Kundo kernel"));
            }
            return FormValidation.ok();
        }
    }
}

