/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.label_verifier.verifiers;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.label_verifier.LabelVerifier;
import hudson.remoting.Channel;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.Collections;
import org.kohsuke.stapler.DataBoundConstructor;

public class ShellScriptVerifier
extends LabelVerifier {
    public final String script;

    @DataBoundConstructor
    public ShellScriptVerifier(String script) {
        this.script = script;
    }

    public void verify(LabelAtom label, Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        Shell shell = new Shell(this.script);
        FilePath script = shell.createScriptFile(root);
        shell.buildCommandLine(script);
        listener.getLogger().println("Validating the label '" + label.getName() + "'");
        int r = root.createLauncher(listener).launch().cmds(shell.buildCommandLine(script)).envs(Collections.singletonMap("LABEL", label.getName())).stdout(listener).pwd(root).join();
        if (r != 0) {
            throw new AbortException("The script failed. Label '" + label.getName() + "' is refused.");
        }
    }
}

