/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.label;

import hudson.Extension;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class LabelColumn
extends ListViewColumn {
    private final String jobName4Label;
    private String result;

    @DataBoundConstructor
    public LabelColumn(String jobName4Label) {
        this.jobName4Label = jobName4Label;
    }

    public LabelColumn() {
        this(null);
    }

    public String getJobName4Label() {
        return this.jobName4Label;
    }

    public String getLabel(Job job) {
        String[] jobNames;
        for (String element : jobNames = this.splitJobs(this.jobName4Label)) {
            String[] jobName = null;
            String prefix = null;
            String splitterBegin = "<";
            String splitterEnd = ">";
            if (element.contains(splitterBegin)) {
                jobName = element.split(splitterBegin);
                element = jobName[0];
                prefix = jobName[1];
            }
            if (job.getName().equals(element)) {
                if (prefix != null) {
                    String lastLabel;
                    String[] tmpArray = prefix.split(splitterEnd);
                    this.result = lastLabel = this.specialLabel(job, tmpArray[0]);
                } else {
                    String lastLabel;
                    this.result = lastLabel = this.defaultLabel(job);
                }
                prefix = null;
                break;
            }
            this.result = "kein Label vorhanden";
        }
        return this.result;
    }

    public String[] splitJobs(String jobName4Label) {
        System.out.println(jobName4Label);
        String[] jobNames4Label = jobName4Label.split(";");
        return jobNames4Label;
    }

    public String defaultLabel(Job job) {
        String build = "" + job.getBuilds().getLastBuild();
        String labelnumber = build.split("#")[1];
        String lastLabel = job.getName() + "-" + labelnumber;
        return lastLabel;
    }

    public String specialLabel(Job job, String prefix) {
        String build = "" + job.getBuilds().get(1);
        String labelnumber = build.split("#")[1];
        String lastLabel = prefix + labelnumber;
        return lastLabel;
    }

    @Extension
    public static class LabelColumnDescriptor
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return "Label";
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

