/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.labmanager;

import com.vmware.labmanager.LabManager_x0020_SOAP_x0020_interfaceStub;
import hudson.Util;
import hudson.model.Label;
import hudson.plugins.labmanager.LabManager;
import hudson.plugins.labmanager.LabManagerVirtualMachine;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.Scrambler;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabManager
extends Cloud {
    private final String lmHost;
    private final String lmDescription;
    private final String lmOrganization;
    private final String lmWorkspace;
    private final String lmConfiguration;
    private final String username;
    private final String password;
    private LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE lmAuth = null;
    private transient List<LabManagerVirtualMachine> virtualMachineList = null;

    @DataBoundConstructor
    public LabManager(String lmHost, String lmDescription, String lmOrganization, String lmWorkspace, String lmConfiguration, String username, String password) {
        super("LabManager");
        this.lmHost = lmHost;
        this.lmDescription = lmDescription;
        this.lmOrganization = lmOrganization;
        this.lmWorkspace = lmWorkspace.length() != 0 ? lmWorkspace : "main";
        this.lmConfiguration = lmConfiguration;
        this.username = username;
        this.password = Scrambler.scramble((String)Util.fixEmptyAndTrim((String)password));
        LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeader ah = new LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeader();
        ah.setUsername(username);
        ah.setPassword(password);
        this.lmAuth = new LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE();
        this.lmAuth.setAuthenticationHeader(ah);
        this.virtualMachineList = this.retrieveLabManagerVirtualMachines();
    }

    private void fixTrustManager() {
        Security.addProvider((Provider)new DummyTrustProvider());
        Security.setProperty("ssl.TrustManagerFactory.algorithm", "TrustAllCertificates");
    }

    public String getLmHost() {
        return this.lmHost;
    }

    public String getLmDescription() {
        return this.lmDescription;
    }

    public String getLmOrganization() {
        return this.lmOrganization;
    }

    public String getLmWorkspace() {
        return this.lmWorkspace;
    }

    public String getLmConfiguration() {
        return this.lmConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return Scrambler.descramble((String)this.password);
    }

    public LabManager_x0020_SOAP_x0020_interfaceStub getLmStub() {
        this.fixTrustManager();
        LabManager_x0020_SOAP_x0020_interfaceStub lmStub = null;
        try {
            lmStub = new LabManager_x0020_SOAP_x0020_interfaceStub(this.lmHost + "/LabManager/SOAP/LabManager.asmx");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lmStub;
    }

    public LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE getLmAuth() {
        return this.lmAuth;
    }

    private List<LabManagerVirtualMachine> retrieveLabManagerVirtualMachines() {
        LabManager_x0020_SOAP_x0020_interfaceStub lmStub = this.getLmStub();
        ArrayList<LabManagerVirtualMachine> vmList = new ArrayList<LabManagerVirtualMachine>();
        try {
            LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName gscbnReq = new LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName();
            gscbnReq.setName(this.lmConfiguration);
            LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByNameResponse gscbnResp = lmStub.getSingleConfigurationByName(gscbnReq, this.lmAuth);
            LabManager_x0020_SOAP_x0020_interfaceStub.ListMachines lmReq = new LabManager_x0020_SOAP_x0020_interfaceStub.ListMachines();
            lmReq.setConfigurationId(gscbnResp.getGetSingleConfigurationByNameResult().getId());
            LabManager_x0020_SOAP_x0020_interfaceStub.ListMachinesResponse lmResp = lmStub.listMachines(lmReq, this.lmAuth);
            LabManager_x0020_SOAP_x0020_interfaceStub.ArrayOfMachine aom = lmResp.getListMachinesResult();
            for (LabManager_x0020_SOAP_x0020_interfaceStub.Machine mach : aom.getMachine()) {
                vmList.add(new LabManagerVirtualMachine(this, mach.getName()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return vmList;
    }

    public synchronized List<LabManagerVirtualMachine> getLabManagerVirtualMachines() {
        if (this.virtualMachineList == null) {
            this.virtualMachineList = this.retrieveLabManagerVirtualMachines();
        }
        return this.virtualMachineList;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int i) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LabManager");
        sb.append("{Host='").append(this.lmHost).append('\'');
        sb.append(", Description='").append(this.lmDescription).append('\'');
        sb.append(", Organization='").append(this.lmOrganization).append('\'');
        sb.append(", Workspace='").append(this.lmWorkspace).append('\'');
        sb.append(", Configuration='").append(this.lmConfiguration).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

