/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.labmanager;

import com.vmware.labmanager.LabManager_x0020_SOAP_x0020_interfaceStub;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.labmanager.LabManager;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class LabManagerVirtualMachineLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(LabManagerVirtualMachineLauncher.class.getName());
    private ComputerLauncher delegate;
    private String lmDescription;
    private String vmName;
    private int idleAction;
    private Boolean overrideLaunchSupported;
    private static final int MACHINE_STATUS_OFF = 1;
    private static final int MACHINE_STATUS_ON = 2;
    private static final int MACHINE_STATUS_SUSPENDED = 3;
    private static final int MACHINE_STATUS_STUCK = 4;
    private static final int MACHINE_STATUS_INVALID = 128;
    private static final int MACHINE_ACTION_ON = 1;
    private static final int MACHINE_ACTION_OFF = 2;
    private static final int MACHINE_ACTION_SUSPEND = 3;
    private static final int MACHINE_ACTION_RESUME = 4;
    private static final int MACHINE_ACTION_RESET = 5;
    private static final int MACHINE_ACTION_SNAPSHOT = 6;
    private static final int MACHINE_ACTION_REVERT = 7;
    private static final int MACHINE_ACTION_SHUTDOWN = 8;

    @DataBoundConstructor
    public LabManagerVirtualMachineLauncher(ComputerLauncher delegate, String lmDescription, String vmName, String idleOption, Boolean overrideLaunchSupported) {
        this.delegate = delegate;
        this.lmDescription = lmDescription;
        this.vmName = vmName;
        this.idleAction = "Shutdown".equals(idleOption) ? 8 : ("Shutdown and Revert".equals(idleOption) ? 7 : 3);
        this.overrideLaunchSupported = overrideLaunchSupported;
    }

    private LabManager findOurLmInstance() throws RuntimeException {
        if (this.lmDescription != null && this.vmName != null) {
            LabManager labmanager = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof LabManager) || !((LabManager)cloud).getLmDescription().equals(this.lmDescription)) continue;
                labmanager = (LabManager)cloud;
                return labmanager;
            }
        }
        LOGGER.log(Level.SEVERE, "Could not find our Lab Manager instance!");
        throw new RuntimeException("Could not find our Lab Manager instance!");
    }

    private LabManager_x0020_SOAP_x0020_interfaceStub.Machine getMachine(LabManager labmanager, LabManager_x0020_SOAP_x0020_interfaceStub lmStub, LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE lmAuth) throws RemoteException {
        LabManager_x0020_SOAP_x0020_interfaceStub.Machine vm = null;
        LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName gscbnReq = new LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName();
        gscbnReq.setName(labmanager.getLmConfiguration());
        LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByNameResponse gscbnResp = lmStub.getSingleConfigurationByName(gscbnReq, lmAuth);
        LabManager_x0020_SOAP_x0020_interfaceStub.ListMachines lmReq = new LabManager_x0020_SOAP_x0020_interfaceStub.ListMachines();
        lmReq.setConfigurationId(gscbnResp.getGetSingleConfigurationByNameResult().getId());
        LabManager_x0020_SOAP_x0020_interfaceStub.ListMachinesResponse lmResp = lmStub.listMachines(lmReq, lmAuth);
        LabManager_x0020_SOAP_x0020_interfaceStub.ArrayOfMachine aom = lmResp.getListMachinesResult();
        for (LabManager_x0020_SOAP_x0020_interfaceStub.Machine mach : aom.getMachine()) {
            if (!mach.getName().equals(this.vmName)) continue;
            vm = mach;
        }
        return vm;
    }

    private static void performAction(LabManager labmanager, LabManager_x0020_SOAP_x0020_interfaceStub lmStub, LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE lmAuth, LabManager_x0020_SOAP_x0020_interfaceStub.Machine vm, int action) throws RemoteException {
        LabManager_x0020_SOAP_x0020_interfaceStub.MachinePerformAction mpaReq = new LabManager_x0020_SOAP_x0020_interfaceStub.MachinePerformAction();
        mpaReq.setAction(action);
        mpaReq.setMachineId(vm.getId());
        lmStub.machinePerformAction(mpaReq, lmAuth);
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        taskListener.getLogger().println("Starting Virtual Machine...");
        LabManager labmanager = this.findOurLmInstance();
        LabManager_x0020_SOAP_x0020_interfaceStub lmStub = labmanager.getLmStub();
        LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE lmAuth = labmanager.getLmAuth();
        int machineAction = 0;
        LabManager_x0020_SOAP_x0020_interfaceStub.Machine vm = this.getMachine(labmanager, lmStub, lmAuth);
        switch (vm.getStatus()) {
            case 1: {
                machineAction = 1;
                break;
            }
            case 3: {
                machineAction = 4;
                break;
            }
            case 2: {
                break;
            }
            case 4: 
            case 128: {
                LOGGER.log(Level.SEVERE, "Problem with the machine status!");
                throw new IOException("Problem with the machine status");
            }
        }
        if (machineAction != 0) {
            LabManagerVirtualMachineLauncher.performAction((LabManager)labmanager, (LabManager_x0020_SOAP_x0020_interfaceStub)lmStub, (LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE)lmAuth, (LabManager_x0020_SOAP_x0020_interfaceStub.Machine)vm, (int)machineAction);
        }
        this.delegate.launch(slaveComputer, taskListener);
    }

    public void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        taskListener.getLogger().println("Running disconnect procedure...");
        this.delegate.afterDisconnect(slaveComputer, taskListener);
        taskListener.getLogger().println("Shutting down Virtual Machine...");
        LabManager labmanager = this.findOurLmInstance();
        LabManager_x0020_SOAP_x0020_interfaceStub lmStub = labmanager.getLmStub();
        LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE lmAuth = labmanager.getLmAuth();
        try {
            boolean machineAction = false;
            LabManager_x0020_SOAP_x0020_interfaceStub.Machine vm = this.getMachine(labmanager, lmStub, lmAuth);
            switch (vm.getStatus()) {
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    switch (this.idleAction) {
                        case 7: {
                            LabManagerVirtualMachineLauncher.performAction((LabManager)labmanager, (LabManager_x0020_SOAP_x0020_interfaceStub)lmStub, (LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE)lmAuth, (LabManager_x0020_SOAP_x0020_interfaceStub.Machine)vm, (int)2);
                            taskListener.getLogger().println("Waiting 60 seconds for shutdown to complete.");
                            Thread.sleep(60000L);
                        }
                        case 2: 
                        case 3: {
                            LabManagerVirtualMachineLauncher.performAction((LabManager)labmanager, (LabManager_x0020_SOAP_x0020_interfaceStub)lmStub, (LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE)lmAuth, (LabManager_x0020_SOAP_x0020_interfaceStub.Machine)vm, (int)this.idleAction);
                        }
                    }
                    break;
                }
                case 4: 
                case 128: {
                    LOGGER.log(Level.SEVERE, "Problem with the machine status!");
                }
            }
        }
        catch (Throwable t) {
            taskListener.fatalError(t.getMessage(), new Object[]{t});
        }
    }

    public String getLmDescription() {
        return this.lmDescription;
    }

    public String getVmName() {
        return this.vmName;
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public Boolean getOverrideLaunchSupported() {
        return this.overrideLaunchSupported;
    }

    public void setOverrideLaunchSupported(Boolean overrideLaunchSupported) {
        this.overrideLaunchSupported = overrideLaunchSupported;
    }

    public boolean isLaunchSupported() {
        if (this.overrideLaunchSupported == null) {
            return this.delegate.isLaunchSupported();
        }
        LOGGER.log(Level.FINE, "Launch support is overridden to always return: " + this.overrideLaunchSupported);
        return this.overrideLaunchSupported;
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

