/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.labmanager;

import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.labmanager.LabManager;
import hudson.plugins.labmanager.LabManagerVirtualMachine;
import hudson.plugins.labmanager.LabManagerVirtualMachineLauncher;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabManagerVirtualMachineSlave
extends Slave {
    private final String lmDescription;
    private final String vmName;
    private final String idleOption;

    @DataBoundConstructor
    public LabManagerVirtualMachineSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, LabManagerVirtualMachineLauncher launcher, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String lmDescription, String vmName, String idleOption, boolean launchSupportForced) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new LabManagerVirtualMachineLauncher(delegateLauncher, lmDescription, vmName, idleOption, launchSupportForced ? Boolean.TRUE : null), retentionStrategy, nodeProperties);
        this.lmDescription = lmDescription;
        this.vmName = vmName;
        this.idleOption = idleOption;
    }

    public String getLmDescription() {
        return this.lmDescription;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getIdleOption() {
        return this.idleOption;
    }

    public boolean isLaunchSupportForced() {
        return ((LabManagerVirtualMachineLauncher)this.getLauncher()).getOverrideLaunchSupported() == Boolean.TRUE;
    }

    public void setLaunchSupportForced(boolean slaveLaunchesOnBootup) {
        ((LabManagerVirtualMachineLauncher)this.getLauncher()).setOverrideLaunchSupported(slaveLaunchesOnBootup ? Boolean.TRUE : null);
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((LabManagerVirtualMachineLauncher)this.getLauncher()).getDelegate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        private String lmDescription;
        private String vmName;
        private String idleOption;
        private boolean launchSupportForced = true;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual computer running under Lab Manager";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<LabManagerVirtualMachine> getDefinedLabManagerVirtualMachines(String lmDescription) {
            ArrayList<LabManagerVirtualMachine> virtualMachinesList = new ArrayList<LabManagerVirtualMachine>();
            if (lmDescription != null && !lmDescription.equals("")) {
                LabManager hypervisor = null;
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof LabManager) || !((LabManager)cloud).getLmDescription().equals(lmDescription)) continue;
                    hypervisor = (LabManager)cloud;
                    break;
                }
                virtualMachinesList.addAll(hypervisor.getLabManagerVirtualMachines());
            }
            return virtualMachinesList;
        }

        public List<LabManager> getLabmanagers() {
            ArrayList<LabManager> result = new ArrayList<LabManager>();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof LabManager)) continue;
                result.add((LabManager)cloud);
            }
            return result;
        }

        public List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor launcher : Functions.getComputerLauncherDescriptors()) {
                if (LabManagerVirtualMachineLauncher.class.isAssignableFrom(launcher.clazz)) continue;
                result.add((Descriptor<ComputerLauncher>)launcher);
            }
            return result;
        }

        public List<String> getIdleOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("Shutdown");
            options.add("Shutdown and Revert");
            options.add("Suspend");
            return options;
        }

        public String getLmDescription() {
            return this.lmDescription;
        }

        public String getVmName() {
            return this.vmName;
        }

        public String getIdleOption() {
            return this.idleOption;
        }

        public boolean isLaunchSupportForced() {
            return this.launchSupportForced;
        }
    }
}

