/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.labmanager;

import com.vmware.labmanager.LabManager_x0020_SOAP_x0020_interfaceStub;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.plugins.labmanager.LabManagerVirtualMachine;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabManager
extends Cloud {
    private final String lmHost;
    private final String lmDescription;
    private final String lmOrganization;
    private final String lmWorkspace;
    private final String lmConfiguration;
    private final String username;
    private final String password;
    private LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE lmAuth = null;

    @DataBoundConstructor
    public LabManager(String lmHost, String lmDescription, String lmOrganization, String lmWorkspace, String lmConfiguration, String username, String password) {
        super("LabManager");
        this.lmHost = lmHost;
        this.lmDescription = lmDescription;
        this.lmOrganization = lmOrganization;
        this.lmWorkspace = lmWorkspace.length() != 0 ? lmWorkspace : "main";
        this.lmConfiguration = lmConfiguration;
        this.username = username;
        this.password = Scrambler.scramble((String)Util.fixEmptyAndTrim((String)password));
        LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeader ah = new LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeader();
        ah.setUsername(username);
        ah.setPassword(password);
        this.lmAuth = new LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE();
        this.lmAuth.setAuthenticationHeader(ah);
    }

    private void fixTrustManager() {
        Security.addProvider(new DummyTrustProvider());
        Security.setProperty("ssl.TrustManagerFactory.algorithm", "TrustAllCertificates");
    }

    public String getLmHost() {
        return this.lmHost;
    }

    public String getLmDescription() {
        return this.lmDescription;
    }

    public String getLmOrganization() {
        return this.lmOrganization;
    }

    public String getLmWorkspace() {
        return this.lmWorkspace;
    }

    public String getLmConfiguration() {
        return this.lmConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return Scrambler.descramble((String)this.password);
    }

    public LabManager_x0020_SOAP_x0020_interfaceStub getLmStub() {
        this.fixTrustManager();
        LabManager_x0020_SOAP_x0020_interfaceStub lmStub = null;
        try {
            lmStub = new LabManager_x0020_SOAP_x0020_interfaceStub(this.lmHost + "/LabManager/SOAP/LabManager.asmx");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lmStub;
    }

    public LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE getLmAuth() {
        return this.lmAuth;
    }

    public synchronized List<LabManagerVirtualMachine> getLabManagerVirtualMachines() {
        LabManager_x0020_SOAP_x0020_interfaceStub lmStub = this.getLmStub();
        ArrayList<LabManagerVirtualMachine> vmList = new ArrayList<LabManagerVirtualMachine>();
        try {
            LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName gscbnReq = new LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName();
            gscbnReq.setName(this.lmConfiguration);
            LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByNameResponse gscbnResp = lmStub.getSingleConfigurationByName(gscbnReq, this.lmAuth);
            LabManager_x0020_SOAP_x0020_interfaceStub.ListMachines lmReq = new LabManager_x0020_SOAP_x0020_interfaceStub.ListMachines();
            lmReq.setConfigurationId(gscbnResp.getGetSingleConfigurationByNameResult().getId());
            LabManager_x0020_SOAP_x0020_interfaceStub.ListMachinesResponse lmResp = lmStub.listMachines(lmReq, this.lmAuth);
            LabManager_x0020_SOAP_x0020_interfaceStub.ArrayOfMachine aom = lmResp.getListMachinesResult();
            for (LabManager_x0020_SOAP_x0020_interfaceStub.Machine mach : aom.getMachine()) {
                vmList.add(new LabManagerVirtualMachine(this, mach.getName()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return vmList;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int i) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LabManager");
        sb.append("{Host='").append(this.lmHost).append('\'');
        sb.append(", Description='").append(this.lmDescription).append('\'');
        sb.append(", Organization='").append(this.lmOrganization).append('\'');
        sb.append(", Workspace='").append(this.lmWorkspace).append('\'');
        sb.append(", Configuration='").append(this.lmConfiguration).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static class DummyTrustProvider
    extends Provider {
        public DummyTrustProvider() {
            super("DummyTrustProvider", 1.0, "Trust certificates");
            this.put("TrustManagerFactory.TrustAllCertificates", MyTrustManagerFactory.class.getName());
        }

        protected static class MyX509TrustManager
        implements X509TrustManager {
            protected MyX509TrustManager() {
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }

        protected static class MyTrustManagerFactory
        extends TrustManagerFactorySpi {
            protected void engineInit(KeyStore keystore) {
            }

            protected void engineInit(ManagerFactoryParameters mgrparams) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{new MyX509TrustManager()};
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public final ConcurrentMap<String, LabManager> hypervisors = new ConcurrentHashMap<String, LabManager>();
        private String lmHost;
        private String lmOrganization;
        private String lmWorkspace;
        private String lmConfiguration;
        private String username;
        private String password;

        public String getDisplayName() {
            return "Lab Manager";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.lmHost = o.getString("lmHost");
            this.lmOrganization = o.getString("lmOrganization");
            this.lmWorkspace = o.getString("lmWorkspace");
            this.lmConfiguration = o.getString("lmConfiguration");
            this.username = o.getString("username");
            this.password = o.getString("password");
            this.save();
            return super.configure(req, o);
        }

        public FormValidation doTestConnection(@QueryParameter String lmHost, @QueryParameter String lmOrganization, @QueryParameter String lmDescription, @QueryParameter String lmWorkspace, @QueryParameter String lmConfiguration, @QueryParameter String username, @QueryParameter String password) {
            try {
                if (lmHost.length() == 0) {
                    return FormValidation.error((String)"Lab Manager host is not specified");
                }
                if (!lmHost.startsWith("https://")) {
                    return FormValidation.error((String)"Lab Manager host must start with https://");
                }
                if (lmOrganization.length() == 0) {
                    return FormValidation.error((String)"Lab Manager organization is not specified");
                }
                if (lmConfiguration.length() == 0) {
                    return FormValidation.error((String)"Lab Manager configuration is not specified");
                }
                if (username.length() == 0) {
                    return FormValidation.error((String)"Username is not specified");
                }
                if (password.length() == 0) {
                    return FormValidation.error((String)"Password is not specified");
                }
                Security.addProvider(new DummyTrustProvider());
                Security.setProperty("ssl.TrustManagerFactory.algorithm", "TrustAllCertificates");
                LabManager_x0020_SOAP_x0020_interfaceStub stub = new LabManager_x0020_SOAP_x0020_interfaceStub(lmHost + "/LabManager/SOAP/LabManager.asmx");
                LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeader ah = new LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeader();
                ah.setUsername(username);
                ah.setPassword(password);
                LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE ahe = new LabManager_x0020_SOAP_x0020_interfaceStub.AuthenticationHeaderE();
                ahe.setAuthenticationHeader(ah);
                LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName request = new LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByName();
                request.setName(lmConfiguration);
                LabManager_x0020_SOAP_x0020_interfaceStub.GetSingleConfigurationByNameResponse resp = stub.getSingleConfigurationByName(request, ahe);
                if (lmConfiguration.equals(resp.getGetSingleConfigurationByNameResult().getName())) {
                    return FormValidation.ok((String)"Connected successfully");
                }
                return FormValidation.error((String)"Could not login and retrieve basic information to confirm setup");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

