/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.lastfailureversioncolumn;

import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.lastfailureversioncolumn.Messages;
import hudson.views.ListViewColumn;
import java.text.DateFormat;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastFailureVersionColumn
extends ListViewColumn {
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new DescriptorImpl();

    public String getShortName(Job job) {
        Run lastFailedBuild = job.getLastFailedBuild();
        StringBuilder stringBuilder = new StringBuilder();
        if (lastFailedBuild != null) {
            String failedDate = DateFormat.getDateTimeInstance().format(lastFailedBuild.getTimestamp().getTime());
            stringBuilder.append(failedDate);
            String tempDescription = lastFailedBuild.getDescription();
            int index = -1;
            if (tempDescription != null) {
                index = tempDescription.indexOf("[version]");
            }
            stringBuilder.append(" (<a href=\"");
            stringBuilder.append(lastFailedBuild.getUrl());
            stringBuilder.append("\">");
            if (index != -1) {
                stringBuilder.append(tempDescription.substring(index + 9).trim());
            } else {
                stringBuilder.append(Integer.toString(lastFailedBuild.getNumber()));
            }
            stringBuilder.append("</a>)");
        } else {
            stringBuilder.append("N/A");
        }
        return stringBuilder.toString();
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptorImpl
    extends Descriptor<ListViewColumn> {
        private DescriptorImpl() {
        }

        public ListViewColumn newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new LastFailureVersionColumn();
        }

        public String getDisplayName() {
            return Messages.LastFailureVersionColumn_DisplayName();
        }
    }
}

