/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.lavalamp;

import com.ftdichip.ftd2xx.FTD2xxException;
import com.ingenotech.annotations.Version;
import com.ingenotech.lavalamp.BuildState;
import com.ingenotech.lavalamp.Log;
import com.ingenotech.lavalamp.TCPListener;
import com.ingenotech.lavalamp.UDPListener;
import com.ingenotech.lavalamp.ftdi.DeviceController;
import com.ingenotech.tools.VersionReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

@Version(version="1.3")
public class LavaLampServer {
    public static final String VERSION;
    private DeviceController device = new DeviceController();
    private TCPListener tcpListener;
    private UDPListener udpListener;

    public LavaLampServer(InetSocketAddress tcpAddress, InetSocketAddress udpAddress, InetAddress multicastAddress) throws FTD2xxException, IOException {
        this.device.open();
        if (tcpAddress != null && tcpAddress.getPort() > 0) {
            try {
                this.tcpListener = new TCPListener(this, tcpAddress);
            }
            catch (IOException iox) {
                throw new IOException("TCPListener at: " + tcpAddress, iox);
            }
        }
        if (udpAddress != null && udpAddress.getPort() > 0) {
            try {
                this.udpListener = new UDPListener(this, udpAddress, multicastAddress);
            }
            catch (IOException iox) {
                throw new IOException("UDPListener at: " + udpAddress + " (mc:" + multicastAddress + ")", iox);
            }
        }
    }

    public void updateState(BuildState bs) {
        Log.log("updateState(" + bs + ")");
        switch (bs.getStatus()) {
            case SUCCESS: {
                this.device.redLampAlert(false);
                this.device.setBeep(false);
                this.device.setLamp(false);
                break;
            }
            case FAILURE: {
                this.device.redLampAlert(true);
                this.device.beepAlert1();
                break;
            }
            case UNSTABLE: {
                this.device.redLampAlert(false);
                this.device.setLamp(true);
                this.device.beepAlert2();
                break;
            }
            case NOT_BUILT: {
                this.device.redLampAlert(false);
                this.device.setLamp(true);
                this.device.beepAlert2();
                break;
            }
            case ABORTED: {
                this.device.redLampAlert(false);
                this.device.setLamp(true);
                this.device.beepAlert2();
            }
        }
    }

    public void setMute(boolean mute) {
        this.device.setMute(mute);
    }

    public void close() {
        if (this.tcpListener != null) {
            this.tcpListener.close();
        }
        if (this.udpListener != null) {
            this.udpListener.close();
        }
        try {
            this.device.close();
        }
        catch (FTD2xxException fTD2xxException) {
            // empty catch block
        }
    }

    public void run() {
        if (this.tcpListener != null) {
            this.tcpListener.start();
        }
        if (this.udpListener != null) {
            this.udpListener.start();
        }
        this.wait(new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wait(Object lock) {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int tcpPort = 1999;
        try {
            if (argv.length >= 1) {
                tcpPort = Integer.parseInt(argv[0]);
            }
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        int udpPort = tcpPort;
        try {
            if (argv.length >= 2) {
                udpPort = Integer.parseInt(argv[1]);
            }
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        InetAddress mcAddress = null;
        try {
            if (argv.length >= 3) {
                mcAddress = InetAddress.getByName(argv[2]);
            }
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        InetSocketAddress tcpAddress = new InetSocketAddress((InetAddress)null, tcpPort);
        InetSocketAddress udpAddress = new InetSocketAddress((InetAddress)null, udpPort);
        LavaLampServer bpa = null;
        try {
            Log.log(VERSION + " starting...");
            bpa = new LavaLampServer(tcpAddress, udpAddress, mcAddress);
            bpa.run();
        }
        finally {
            if (bpa != null) {
                bpa.close();
            }
            Log.log("exit.");
        }
    }

    static {
        String v = new VersionReader(LavaLampServer.class).getVersion();
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            if (hostname.startsWith("localhost")) {
                hostname = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        VERSION = "LavaLamp server" + (v == null ? "" : " V" + v) + (hostname == null ? "" : " @" + hostname);
    }
}

