/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.lavalamp;

import com.ingenotech.lavalamp.ConnectionHandler;
import com.ingenotech.lavalamp.LavaLampServer;
import com.ingenotech.lavalamp.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPListener
extends Thread {
    private ConnectionHandler handler;
    private ServerSocket server;
    private volatile boolean run;

    public TCPListener(LavaLampServer controller, InetSocketAddress listenAddress) throws IOException {
        this.handler = new ConnectionHandler(controller);
        this.server = new ServerSocket();
        this.server.bind(listenAddress);
        this.run = true;
    }

    public void close() {
        try {
            this.run = false;
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Log.log("TCPListener started on: " + this.server.getLocalSocketAddress());
        block4: while (true) {
            try {
                while (this.run) {
                    Socket s = this.server.accept();
                    this.handler.handleConnection(s);
                    try {
                        s.close();
                        continue block4;
                    }
                    catch (IOException iox) {
                        Log.log("TCPListener.run()", iox);
                    }
                }
                break;
            }
            catch (IOException iox) {
                Log.log("TCPListener.run() socket exception:", iox);
                break;
            }
        }
        Log.log("TCPListener exited.");
    }
}

