/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.lavalamp.ftdi;

import com.ftdichip.ftd2xx.BitBangMode;
import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.DeviceDescriptor;
import com.ftdichip.ftd2xx.FTD2xxException;
import com.ftdichip.ftd2xx.Service;
import com.ingenotech.lavalamp.Log;
import com.ingenotech.lavalamp.ftdi.Beeper;
import com.ingenotech.lavalamp.ftdi.Beeper1;
import com.ingenotech.lavalamp.ftdi.Beeper2;
import com.ingenotech.lavalamp.ftdi.DeviceBits;
import com.ingenotech.lavalamp.ftdi.DeviceWriter;
import com.ingenotech.lavalamp.ftdi.RedLamp;

public class DeviceController
implements DeviceWriter {
    private Device device;
    private int currentData;
    private RedLamp redLamp;
    private Beeper beeper;
    private boolean mute = false;

    public DeviceController() throws FTD2xxException {
        Device[] devices = Service.listDevices();
        if (devices.length < 1) {
            throw new IllegalStateException("FTDI device not found!");
        }
        this.device = devices[0];
        DeviceDescriptor desc = this.device.getDeviceDescriptor();
        Log.log("Manufacturer: " + desc.getManufacturer());
        Log.log("Serial#: " + desc.getSerialNumber());
        Log.log("Product descr: " + desc.getProductDescription());
    }

    public void open() throws FTD2xxException {
        this.device.open();
        this.device.setBitBangMode(15, BitBangMode.ASYNCHRONOUS);
        this.write(0);
    }

    public void close() throws FTD2xxException {
        this.write(0);
        this.device.close();
    }

    private void write(int data) throws FTD2xxException {
        this.device.write(data &= 0xF);
        this.currentData = data;
    }

    private void set(DeviceBits bit) throws FTD2xxException {
        int data = DeviceBits.set(this.currentData, bit);
        this.write(data);
    }

    private void clear(DeviceBits bit) throws FTD2xxException {
        int data = DeviceBits.clear(this.currentData, bit);
        this.write(data);
    }

    public synchronized void beepAlert1() {
        if (this.beeper == null || !this.beeper.isAlive()) {
            this.beeper = new Beeper1(this);
            this.beeper.start();
        }
    }

    public synchronized void beepAlert2() {
        if (this.beeper == null || !this.beeper.isAlive()) {
            this.beeper = new Beeper2(this);
            this.beeper.start();
        }
    }

    public synchronized void redLampAlert(boolean on) {
        if (on) {
            if (this.redLamp == null || !this.redLamp.isAlive()) {
                this.redLamp = new RedLamp(this);
                this.redLamp.start();
            }
        } else if (this.redLamp != null) {
            this.redLamp.cancel();
        }
    }

    @Override
    public synchronized void setLamp(boolean on) {
        try {
            if (on) {
                this.set(DeviceBits.LAMP);
            } else {
                this.clear(DeviceBits.LAMP);
            }
        }
        catch (FTD2xxException fx) {
            Log.log("setLamp(" + on + ")", fx);
        }
    }

    @Override
    public synchronized void setBeep(boolean on) {
        try {
            if (on && !this.mute) {
                this.set(DeviceBits.BEEP);
            } else {
                this.clear(DeviceBits.BEEP);
            }
        }
        catch (FTD2xxException fx) {
            Log.log("setBeep(" + on + ")", fx);
        }
    }

    public void setMute(boolean mute) {
        Log.log("setMute(" + mute + ")");
        this.mute = mute;
    }
}

