/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx;

import com.ftdichip.ftd2xx.BitBangMode;
import com.ftdichip.ftd2xx.DeviceDescriptor;
import com.ftdichip.ftd2xx.DeviceInputStream;
import com.ftdichip.ftd2xx.DeviceOututStream;
import com.ftdichip.ftd2xx.DeviceType;
import com.ftdichip.ftd2xx.EEPROM;
import com.ftdichip.ftd2xx.FTD2xxException;
import com.ftdichip.ftd2xx.ModemStatus;
import com.ftdichip.ftd2xx.Port;
import com.ftdichip.ftd2xx.Service;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.util.Localizer;

public class Device {
    private static final Logger logger = Logger.getLogger(Device.class.getName());
    private static final int DEFAULT_RX_TIMEOUT = 300;
    private static final int DEFAULT_TX_TIMEOUT = 300;
    private EEPROM eeprom = new EEPROM(this);
    private Port port = new Port(this);
    private long resetPipeRetryCount = 50L;
    private long handle = -1L;
    private long locationID;
    private DeviceType type;
    private long readTimeout = 300L;
    private long writeTimeout = 300L;

    protected Device(long l, long l2) throws FTD2xxException {
        this.locationID = l;
        this.type = DeviceType.valueOf(l2);
        this.open();
        this.getDeviceDescriptor();
        this.close();
    }

    public DeviceType getType() {
        return this.type;
    }

    public Port getPort() {
        return this.port;
    }

    public DeviceDescriptor getDeviceDescriptor() throws FTD2xxException {
        return this.eeprom.getDeviceDescriptor();
    }

    long getHandle() {
        return this.handle;
    }

    private void checkIsOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(Localizer.getLocalizedMessage(Device.class, (String)"error.notOpen"));
        }
    }

    public void open() throws FTD2xxException {
        if (this.isOpen()) {
            throw new IllegalStateException(Localizer.getLocalizedMessage(Device.class, (String)"error.alreadyOpen"));
        }
        logger.info(String.format("Open device %d.", this.locationID));
        this.handle = Device.open(this.locationID);
        Service.configureDevice(this);
    }

    private static native long open(long var0) throws FTD2xxException;

    public void close() throws FTD2xxException {
        this.checkIsOpen();
        Device.close(this.handle);
        this.handle = -1L;
    }

    private static native void close(long var0) throws FTD2xxException;

    public boolean isOpen() {
        return this.handle != -1L;
    }

    public void reset() throws FTD2xxException {
        this.checkIsOpen();
        Device.reset(this.handle);
    }

    private static native void reset(long var0) throws FTD2xxException;

    public void purgeReceiveBuffer() throws FTD2xxException {
        this.checkIsOpen();
        Device.purgeReceiveBuffer(this.handle);
    }

    private static native void purgeReceiveBuffer(long var0) throws FTD2xxException;

    public void purgeTransmitBuffer() throws FTD2xxException {
        this.checkIsOpen();
        Device.purgeTransmitBuffer(this.handle);
    }

    private static native void purgeTransmitBuffer(long var0) throws FTD2xxException;

    public void setTimeout(long l) throws FTD2xxException {
        this.checkIsOpen();
        Device.setTimeouts(this.handle, l, l);
        this.readTimeout = l;
        this.writeTimeout = l;
    }

    public void setReadTimeout(long l) throws FTD2xxException {
        this.checkIsOpen();
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidTimeout", (Object[])new Object[]{l}));
        }
        Device.setTimeouts(this.handle, l, this.writeTimeout);
        this.readTimeout = l;
    }

    public long getReadTimeout() {
        this.checkIsOpen();
        return this.readTimeout;
    }

    public long getWriteTimeout() {
        this.checkIsOpen();
        return this.writeTimeout;
    }

    public void setWriteTimeout(long l) throws FTD2xxException {
        this.checkIsOpen();
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidTimeout", (Object[])new Object[]{l}));
        }
        Device.setTimeouts(this.handle, this.readTimeout, l);
        this.writeTimeout = l;
    }

    private static native void setTimeouts(long var0, long var2, long var4) throws FTD2xxException;

    public long getReceiveQueueStatus() throws FTD2xxException {
        this.checkIsOpen();
        return Device.getReceiveQueueStatus(this.handle);
    }

    private static native long getReceiveQueueStatus(long var0) throws FTD2xxException;

    public long getTransmitQueueStatus() throws FTD2xxException {
        this.checkIsOpen();
        return Device.getTransmitQueueStatus(this.handle);
    }

    private static native long getTransmitQueueStatus(long var0) throws FTD2xxException;

    public long getResetPipeRetryCount() {
        this.checkIsOpen();
        return this.resetPipeRetryCount;
    }

    public void setResetPipeRetryCount(long l) throws FTD2xxException {
        this.checkIsOpen();
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidResetPipeRetryCount", (Object[])new Object[]{l}));
        }
        Device.setResetPipeRetryCount(this.handle, l);
        this.resetPipeRetryCount = l;
    }

    private static native void setResetPipeRetryCount(long var0, long var2) throws FTD2xxException;

    public ModemStatus getModemStatus() throws FTD2xxException {
        this.checkIsOpen();
        return ModemStatus.byValue(Device.getModemStatus(this.handle));
    }

    private static native long getModemStatus(long var0) throws FTD2xxException;

    public int getLatencyTimer() throws FTD2xxException {
        this.checkIsOpen();
        return Device.getLatencyTimer(this.handle);
    }

    private static native int getLatencyTimer(long var0) throws FTD2xxException;

    public void setLatencyTimer(int n) throws FTD2xxException {
        this.checkIsOpen();
        if (n < 1 || n > 255) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidLatencyTimer", (Object[])new Object[]{n}));
        }
        Device.setLatencyTimer(this.handle, n);
    }

    private static native void setLatencyTimer(long var0, int var2) throws FTD2xxException;

    public BitBangMode getBitBangMode() throws FTD2xxException {
        this.checkIsOpen();
        return BitBangMode.valueOf(Device.getBitBangMode(this.handle));
    }

    private static native int getBitBangMode(long var0) throws FTD2xxException;

    public void setBitBangMode(int n, BitBangMode bitBangMode) throws FTD2xxException {
        this.checkIsOpen();
        if (n < 0 || (long)n > 255L) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidBitMask", (Object[])new Object[]{n}));
        }
        Device.setBitBangMode(this.handle, n, bitBangMode.value);
    }

    public void resetBitBangMode() throws FTD2xxException {
        this.setBitBangMode(0, BitBangMode.RESET);
    }

    private static native void setBitBangMode(long var0, int var2, int var3) throws FTD2xxException;

    public void setUSBParameters(long l, long l2) throws FTD2xxException {
        this.checkIsOpen();
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidRxBufferSize", (Object[])new Object[]{l}));
        }
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidTxBufferSize", (Object[])new Object[]{l2}));
        }
        Device.setUSBParameters(this.handle, l, l2);
    }

    private static native void setUSBParameters(long var0, long var2, long var4) throws FTD2xxException;

    public int read() throws FTD2xxException {
        byte[] byArray = new byte[]{-1};
        this.read(byArray);
        return byArray[0];
    }

    public int read(byte[] byArray) throws FTD2xxException {
        this.checkIsOpen();
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws FTD2xxException {
        this.checkIsOpen();
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidBuffer"));
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidOffset", (Object[])new Object[]{byArray.length, n}));
        }
        int n3 = Device.read(this.handle, byArray, n, n2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Localizer.getLocalizedMessage(Device.class, (String)"read.logger.fine", (Object[])new Object[]{this.format(byArray, n, n3)}));
        }
        return n3;
    }

    public InputStream getInputStream() {
        this.checkIsOpen();
        return new DeviceInputStream(this);
    }

    public OutputStream getOutputStream() {
        this.checkIsOpen();
        return new DeviceOututStream(this);
    }

    private static synchronized native int read(long var0, byte[] var2, int var3, int var4) throws FTD2xxException;

    public void write(int n) throws FTD2xxException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws FTD2xxException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws FTD2xxException {
        this.checkIsOpen();
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidBuffer"));
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Device.class, (String)"error.invalidOffset", (Object[])new Object[]{byArray.length, n}));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Localizer.getLocalizedMessage(Device.class, (String)"write.logger.fine", (Object[])new Object[]{this.format(byArray, n, n2)}));
        }
        Device.write(this.handle, byArray, n, n2);
    }

    private static native void write(long var0, byte[] var2, int var3, int var4) throws FTD2xxException;

    private String format(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(String.format("%02X ", byArray[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    public synchronized EEPROM getEEPROM() {
        return this.eeprom;
    }
}

