/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx;

import com.ftdichip.ftd2xx.InvalidDeviceDescriptorException;
import javax.util.Localizer;

public class DeviceDescriptor {
    private static final int MAX_HEADER_LENGTH = 48;
    private long signature1 = 0L;
    private long signature2 = -1L;
    private long version = 0L;
    private int vendorID;
    private int productID;
    private String manufacturer = "";
    private String manufacturerID = "";
    private String productDescription = "";
    private String serialNumber = "";
    private int maxPower;
    private boolean pnpEnabled;
    private boolean selfPowered;
    private boolean remoteWakeupCapable;

    protected void validate() throws InvalidDeviceDescriptorException {
        if (this.manufacturer.length() + this.manufacturerID.length() + this.productDescription.length() + this.serialNumber.length() > 48) {
            throw new InvalidDeviceDescriptorException(Localizer.getLocalizedMessage(DeviceDescriptor.class, (String)"error.invalidHeaderLength", (Object[])new Object[]{48}));
        }
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String string) {
        if (string == null) {
            this.manufacturer = "";
        }
        this.manufacturer = string;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public void setManufacturerID(String string) {
        if (string == null) {
            this.manufacturerID = "";
        }
        this.manufacturerID = string;
    }

    public int getMaxPower() {
        return this.maxPower;
    }

    public void setMaxPower(int n) {
        this.maxPower = n;
    }

    public boolean isPnpEnabled() {
        return this.pnpEnabled;
    }

    public void setPnpEnabled(boolean bl) {
        this.pnpEnabled = bl;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String string) {
        if (string == null) {
            this.productDescription = "";
        }
        this.productDescription = string;
    }

    public int getProductID() {
        return this.productID;
    }

    public void setProductID(int n) {
        this.productID = n;
    }

    public boolean isRemoteWakeupCapable() {
        return this.remoteWakeupCapable;
    }

    public void setRemoteWakeupCapable(boolean bl) {
        this.remoteWakeupCapable = bl;
    }

    public boolean isSelfPowered() {
        return this.selfPowered;
    }

    public void setSelfPowered(boolean bl) {
        this.selfPowered = bl;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public long getSignature1() {
        return this.signature1;
    }

    public void setSignature1(long l) {
        this.signature1 = l;
    }

    public long getSignature2() {
        return this.signature2;
    }

    public void setSignature2(long l) {
        this.signature2 = l;
    }

    public int getVendorID() {
        return this.vendorID;
    }

    public void setVendorID(int n) {
        this.vendorID = n;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }
}

