/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx;

import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.DeviceDescriptor;
import com.ftdichip.ftd2xx.FTD2xxException;
import javax.util.Localizer;

public class EEPROM {
    private Device device;
    private DeviceDescriptor deviceDescriptor;

    EEPROM(Device device) {
        this.device = device;
    }

    private void checkIsOpen() {
        if (!this.device.isOpen()) {
            throw new IllegalStateException(Localizer.getLocalizedMessage(EEPROM.class, (String)"error.notOpen"));
        }
    }

    DeviceDescriptor getDeviceDescriptor() throws FTD2xxException {
        if (this.deviceDescriptor == null) {
            this.deviceDescriptor = this.readDeviceDescriptor();
        }
        return this.deviceDescriptor;
    }

    public DeviceDescriptor readDeviceDescriptor() throws FTD2xxException {
        this.checkIsOpen();
        return EEPROM.readDeviceDescriptor(this.device.getHandle());
    }

    private static native DeviceDescriptor readDeviceDescriptor(long var0) throws FTD2xxException;

    public void writeDeviceDescriptor(DeviceDescriptor deviceDescriptor) throws FTD2xxException {
        this.checkIsOpen();
        deviceDescriptor.validate();
        EEPROM.writeDeviceDescriptor(this.device.getHandle(), deviceDescriptor);
        this.deviceDescriptor = deviceDescriptor;
    }

    private static native void writeDeviceDescriptor(long var0, DeviceDescriptor var2) throws FTD2xxException;

    public int getUserAreaSize() throws FTD2xxException {
        this.checkIsOpen();
        return EEPROM.readUserAreaSize(this.device.getHandle());
    }

    private static native int readUserAreaSize(long var0) throws FTD2xxException;

    public int readUserArea(byte[] byArray) throws FTD2xxException {
        this.checkIsOpen();
        return EEPROM.readUserArea(this.device.getHandle(), byArray);
    }

    private static native int readUserArea(long var0, byte[] var2) throws FTD2xxException;

    public void writeUserArea(byte[] byArray) throws FTD2xxException {
        this.checkIsOpen();
        EEPROM.writeUserArea(this.device.getHandle(), byArray);
    }

    private static native void writeUserArea(long var0, byte[] var2) throws FTD2xxException;

    public void erase() throws FTD2xxException {
        this.checkIsOpen();
        EEPROM.erase(this.device.getHandle());
    }

    private static native void erase(long var0) throws FTD2xxException;
}

