/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx;

import com.ftdichip.ftd2xx.EEPROMException;
import com.ftdichip.ftd2xx.FTD2xxException;
import java.util.NoSuchElementException;
import javax.util.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FTStatus {
    FT_OK,
    FT_INVALID_HANDLE,
    FT_DEVICE_NOT_FOUND,
    FT_DEVICE_NOT_OPENED,
    FT_IO_ERROR,
    FT_INSUFFICIENT_RESOURCES,
    FT_INVALID_PARAMETER,
    FT_INVALID_BAUD_RATE,
    FT_DEVICE_NOT_OPENED_FOR_ERASE,
    FT_DEVICE_NOT_OPENED_FOR_WRITE,
    FT_FAILED_TO_WRITE_DEVICE,
    FT_EEPROM_READ_FAILED,
    FT_EEPROM_WRITE_FAILED,
    FT_EEPROM_ERASE_FAILED,
    FT_EEPROM_NOT_PRESENT,
    FT_EEPROM_NOT_PROGRAMMED,
    FT_INVALID_ARGS,
    FT_NOT_SUPPORTED,
    FT_OTHER_ERROR;


    public static FTStatus byOrdinal(int n) {
        FTStatus fTStatus = null;
        for (FTStatus fTStatus2 : FTStatus.values()) {
            if (fTStatus2.ordinal() != n) continue;
            fTStatus = fTStatus2;
            break;
        }
        if (fTStatus == null) {
            throw new NoSuchElementException("Unknown ordinal: " + n);
        }
        return fTStatus;
    }

    public static String getLocalizedMessage(FTStatus fTStatus) {
        return Localizer.getLocalizedMessage(FTStatus.class, (String)fTStatus.toString());
    }

    static void throwException(int n) throws FTD2xxException {
        try {
            FTStatus fTStatus = FTStatus.byOrdinal(n);
            FTStatus.throwNewException(fTStatus, FTStatus.getLocalizedMessage(fTStatus));
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Localizer.getLocalizedMessage(FTStatus.class, (String)"undefinedStatus", (Object[])new Object[]{n});
            throw new FTD2xxException(string);
        }
        catch (FTD2xxException fTD2xxException) {
            throw fTD2xxException;
        }
        catch (Exception exception) {
            throw (RuntimeException)exception;
        }
    }

    private static void throwNewException(FTStatus fTStatus, String string) throws Exception {
        Exception exception = null;
        switch (fTStatus) {
            case FT_INVALID_HANDLE: 
            case FT_INVALID_PARAMETER: 
            case FT_INVALID_BAUD_RATE: 
            case FT_INVALID_ARGS: {
                exception = new IllegalArgumentException(string);
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_ERASE: 
            case FT_DEVICE_NOT_OPENED_FOR_WRITE: 
            case FT_DEVICE_NOT_OPENED: {
                exception = new IllegalStateException(string);
                break;
            }
            case FT_EEPROM_READ_FAILED: 
            case FT_EEPROM_WRITE_FAILED: 
            case FT_EEPROM_ERASE_FAILED: 
            case FT_EEPROM_NOT_PRESENT: 
            case FT_EEPROM_NOT_PROGRAMMED: {
                exception = new EEPROMException(string);
                break;
            }
            case FT_NOT_SUPPORTED: {
                exception = new UnsupportedOperationException(string);
                break;
            }
            default: {
                exception = new FTD2xxException(string);
            }
        }
        throw exception;
    }
}

